/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.simplifier;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValueFormula;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class ExternalSimplifier {
    private static EvalUtilities util;

    public static void initialize() {
        if (util == null) {
            F.initSymbols(null);
            util = new EvalUtilities();
        }
    }

    public static SymbolicValueFormula.ExpressionBase simplify(SymbolicValueFormula.ExpressionBase expr, LogManagerWithoutDuplicates logger) {
        if (util == null) {
            ExternalSimplifier.initialize();
        }
        try {
            ArrayList<SymbolicValueFormula.SymbolicValue> usedVariables = new ArrayList<SymbolicValueFormula.SymbolicValue>();
            String input = "Simplify[" + ExternalSimplifier.convertFormulaToString(expr, usedVariables) + "]";
            IExpr result = util.evaluate(input);
            return ExternalSimplifier.recursiveConvertExpressionToFormula(result, usedVariables);
        }
        catch (Exception e) {
            logger.logf(Level.FINE, "Error simplifying formula %s: %s", new Object[]{expr.toString(), e.toString()});
            return expr;
        }
    }

    public static Value solve(SymbolicValueFormula.SymbolicValue value, SymbolicValueFormula.ExpressionBase expr, LogManagerWithoutDuplicates logger) {
        if (util == null) {
            ExternalSimplifier.initialize();
        }
        try {
            ArrayList<SymbolicValueFormula.SymbolicValue> usedVariables = new ArrayList<SymbolicValueFormula.SymbolicValue>();
            String formulaString = ExternalSimplifier.convertFormulaToString(expr, usedVariables);
            int toSolveIndex = usedVariables.indexOf(value);
            String variableToSolveFor = "X" + toSolveIndex;
            String input = "Solve[" + formulaString + ", " + variableToSolveFor + "]";
            IExpr result = util.evaluate(input);
            result = result.getAt(1).getAt(1);
            if (result.isRuleAST() && result.getAt(1).toString().equals(variableToSolveFor)) {
                return new NumericValue(Integer.parseInt(result.getAt(2).toString()));
            }
            return null;
        }
        catch (Exception e) {
            logger.logf(Level.FINE, "Error solving formula %s: %s", new Object[]{expr.toString(), e.toString()});
            return null;
        }
    }

    private static String convertFormulaToString(SymbolicValueFormula.ExpressionBase expr, List<SymbolicValueFormula.SymbolicValue> usedVariables) throws UnsupportedFormulaException {
        return ExternalSimplifier.recursiveConvertFormulaToString(expr, usedVariables);
    }

    private static String recursiveConvertFormulaToString(SymbolicValueFormula.ExpressionBase formulaExpr, List<SymbolicValueFormula.SymbolicValue> usedVariables) throws UnsupportedFormulaException {
        if (formulaExpr instanceof SymbolicValueFormula.SymbolicValue) {
            int index = usedVariables.indexOf(formulaExpr);
            if (index == -1) {
                index = usedVariables.size();
                usedVariables.add((SymbolicValueFormula.SymbolicValue)formulaExpr);
            }
            return "X" + index;
        }
        if (formulaExpr instanceof SymbolicValueFormula.BinaryExpression) {
            SymbolicValueFormula.BinaryExpression expr = (SymbolicValueFormula.BinaryExpression)formulaExpr;
            String leftHand = ExternalSimplifier.recursiveConvertFormulaToString(expr.getOperand1(), usedVariables);
            String rightHand = ExternalSimplifier.recursiveConvertFormulaToString(expr.getOperand2(), usedVariables);
            String operator = ExternalSimplifier.operatorIdentifierToOperator(expr.getOperator().toString());
            return "(" + leftHand + " " + operator + " " + rightHand + ")";
        }
        if (formulaExpr instanceof SymbolicValueFormula.ConstantValue) {
            return ((SymbolicValueFormula.ConstantValue)formulaExpr).getValue().asNumericValue().getNumber().toString();
        }
        throw new UnsupportedFormulaException("Unsupported formula: " + formulaExpr);
    }

    private static SymbolicValueFormula.ExpressionBase recursiveConvertExpressionToFormula(IExpr expression, List<SymbolicValueFormula.SymbolicValue> usedVariables) throws UnsupportedFormulaException {
        if (expression.isPlus() || expression.getAt(0).toString().equals("Plus")) {
            SymbolicValueFormula.ExpressionBase leftHand = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(1), usedVariables);
            SymbolicValueFormula.ExpressionBase rightHand = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(2), usedVariables);
            return new SymbolicValueFormula.BinaryExpression(leftHand, rightHand, SymbolicValueFormula.BinaryExpression.BinaryOperator.PLUS, CNumericTypes.INT, CNumericTypes.INT);
        }
        if (expression.isTimes()) {
            SymbolicValueFormula.ExpressionBase leftHand = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(1), usedVariables);
            SymbolicValueFormula.ExpressionBase rightHand = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(2), usedVariables);
            return new SymbolicValueFormula.BinaryExpression(leftHand, rightHand, SymbolicValueFormula.BinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.INT, CNumericTypes.INT);
        }
        if (expression.isPower()) {
            SymbolicValueFormula.ExpressionBase base = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(1), usedVariables);
            SymbolicValueFormula.ExpressionBase power = ExternalSimplifier.recursiveConvertExpressionToFormula(expression.getAt(2), usedVariables);
            if (power instanceof SymbolicValueFormula.ConstantValue && ((SymbolicValueFormula.ConstantValue)power).getValue().asLong(CNumericTypes.INT) == 2L) {
                return new SymbolicValueFormula.BinaryExpression(base, base, SymbolicValueFormula.BinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.INT, CNumericTypes.INT);
            }
            throw new RuntimeException("Power larger than 2 not yet supported.");
        }
        if (expression.isInteger()) {
            return new SymbolicValueFormula.ConstantValue(new NumericValue(Integer.parseInt(expression.toString())));
        }
        if (expression.toString().startsWith("X")) {
            String indexString = expression.toString().substring(1);
            int index = Integer.parseInt(indexString);
            return usedVariables.get(index);
        }
        throw new UnsupportedFormulaException("Unsupported formula: " + expression.toString());
    }

    private static String operatorIdentifierToOperator(String identifier) throws UnsupportedFormulaException {
        switch (identifier) {
            case "PLUS": {
                return "+";
            }
            case "MINUS": {
                return "-";
            }
            case "MULTIPLY": {
                return "*";
            }
            case "EQUALS": {
                return "==";
            }
        }
        throw new UnsupportedFormulaException("Unsupported operand: " + identifier);
    }

    static class UnsupportedFormulaException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedFormulaException(String message) {
            super(message);
        }
    }
}

