/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class ArrayValue
implements Value {
    private final JArrayType arrayType;
    private final Type elementType;
    private final int arraySize;
    private final Value[] values;

    public ArrayValue(JArrayType pType, int pArraySize) {
        this.arrayType = pType;
        this.elementType = this.arrayType.getElementType();
        this.arraySize = pArraySize;
        this.values = new Value[pArraySize];
        Arrays.fill(this.values, this.getInitialValue(pType.getElementType()));
    }

    public ArrayValue(JArrayType pType, List<Value> pValues) {
        this.arrayType = pType;
        this.elementType = this.arrayType.getElementType();
        this.arraySize = pValues.size();
        for (Value currentValue : pValues) {
            this.checkValidValue(currentValue);
        }
        this.values = pValues.toArray(new Value[pValues.size()]);
    }

    private Value getInitialValue(JType pType) {
        if (pType instanceof JClassOrInterfaceType) {
            return NullValue.getInstance();
        }
        if (pType instanceof JSimpleType) {
            switch (((JSimpleType)pType).getType()) {
                case BOOLEAN: {
                    return BooleanValue.valueOf(false);
                }
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return new NumericValue(0L);
                }
            }
            throw new AssertionError((Object)("Unhandled type " + pType.getClass()));
        }
        throw new AssertionError((Object)("Unhandled type " + pType.getClass()));
    }

    public static ArrayValue copyOf(ArrayValue pArrayValue) {
        ArrayValue newArray = new ArrayValue(pArrayValue.arrayType, pArrayValue.arraySize);
        int counter = 0;
        for (Value v : pArrayValue.values) {
            newArray.values[counter] = v instanceof ArrayValue ? ArrayValue.copyOf((ArrayValue)v) : v;
            ++counter;
        }
        return newArray;
    }

    private void checkValidValue(Value pValue) {
        Preconditions.checkNotNull((Object)pValue);
        String errorMessage = "Illegal value " + pValue + " to store in array of type " + this.arrayType;
        if (!pValue.isUnknown()) {
            if (this.arrayType.getDimensions() > 1) {
                if (!(pValue instanceof ArrayValue) && !(pValue instanceof NullValue)) {
                    throw new IllegalArgumentException(errorMessage);
                }
            } else {
                if (this.elementType instanceof JClassOrInterfaceType && !this.isValidComplexValue(pValue)) {
                    throw new IllegalArgumentException(errorMessage);
                }
                if (this.elementType instanceof JSimpleType) {
                    JBasicType concreteType = ((JSimpleType)this.elementType).getType();
                    switch (concreteType) {
                        case BYTE: 
                        case CHAR: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            if (pValue instanceof NumericValue && ((NumericValue)pValue).doubleValue() % 1.0 == 0.0) break;
                            throw new IllegalArgumentException(errorMessage);
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            if (pValue instanceof NumericValue) break;
                            throw new IllegalArgumentException(errorMessage);
                        }
                        case BOOLEAN: {
                            if (pValue instanceof BooleanValue) break;
                            throw new IllegalArgumentException(errorMessage);
                        }
                        default: {
                            throw new IllegalArgumentException(errorMessage);
                        }
                    }
                }
            }
        }
    }

    private boolean isValidComplexValue(Value pValue) {
        Preconditions.checkNotNull((Object)pValue);
        if (pValue.isUnknown() || pValue instanceof NullValue) {
            return true;
        }
        if (pValue instanceof EnumConstantValue) {
            EnumConstantValue concreteValue = (EnumConstantValue)pValue;
            Type enumType = concreteValue.getEnumType();
            if (enumType instanceof JClassType) {
                if (enumType.equals(this.elementType)) {
                    return true;
                }
                Set<JClassOrInterfaceType> superTypes = ((JClassType)enumType).getAllSuperTypesOfClass();
                return superTypes.contains(this.elementType);
            }
            throw new AssertionError((Object)("Unhandled enum type " + enumType));
        }
        return false;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public JArrayType getArrayType() {
        return this.arrayType;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public Value getValueAt(int pIndex) {
        this.checkValidIndex(pIndex);
        return this.values[pIndex];
    }

    public void setValue(Value pValue, int pIndex) {
        this.checkValidValue(pValue);
        this.checkValidIndex(pIndex);
        this.values[pIndex] = pValue;
    }

    private void checkValidIndex(int pIndex) {
        if (pIndex > this.values.length - 1 || pIndex < 0) {
            throw new IllegalArgumentException("Array value has size " + (this.values.length - 1) + " but asked for access at index " + pIndex + ".");
        }
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    @Override
    public NumericValue asNumericValue() {
        return null;
    }

    @Override
    public Long asLong(CType type) {
        return null;
    }
}

