/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class EnumConstantValue
implements Value {
    private final Type classType;
    private final String fullyQualifiedName;

    public EnumConstantValue(Type pEnumType, String pFullyQualifiedName) {
        assert (pEnumType instanceof JClassType || pEnumType instanceof CComplexType);
        this.classType = pEnumType;
        this.fullyQualifiedName = pFullyQualifiedName;
    }

    public Type getEnumType() {
        return this.classType;
    }

    public String getName() {
        return this.fullyQualifiedName;
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    @Override
    public NumericValue asNumericValue() {
        throw new AssertionError((Object)"Enum constant cannot be represented as NumericValue");
    }

    @Override
    public Long asLong(CType pType) {
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof EnumConstantValue) {
            EnumConstantValue concreteOther = (EnumConstantValue)other;
            return concreteOther.classType.equals(this.classType) && concreteOther.fullyQualifiedName.equals(this.fullyQualifiedName);
        }
        return false;
    }

    public int hashCode() {
        return this.classType.hashCode() ^ this.fullyQualifiedName.hashCode();
    }

    public String toString() {
        return this.fullyQualifiedName;
    }
}

