/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigDecimal;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class NumericValue
implements Value,
Serializable {
    private static final long serialVersionUID = -3829943575180448170L;
    private Number number;

    public NumericValue(Number pNumber) {
        this.number = pNumber;
    }

    public Number getNumber() {
        return this.number;
    }

    public long longValue() {
        return this.number.longValue();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.number.toString());
    }

    public String toString() {
        return "NumericValue [number=" + this.number + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof NumericValue) {
            return this.getNumber().equals(((NumericValue)other).getNumber());
        }
        return false;
    }

    @Override
    public boolean isNumericValue() {
        return true;
    }

    public NumericValue negate() {
        return new NumericValue(this.bigDecimalValue().negate());
    }

    public boolean isNull() {
        return this.bigDecimalValue().compareTo(new BigDecimal(0)) == 0;
    }

    @Override
    public NumericValue asNumericValue() {
        return this;
    }

    @Override
    public Long asLong(CType type) {
        Preconditions.checkNotNull((Object)type);
        type = type.getCanonicalType();
        if (!(type instanceof CSimpleType)) {
            return null;
        }
        if (((CSimpleType)type).getType() == CBasicType.INT) {
            return this.longValue();
        }
        return null;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    public int hashCode() {
        return this.number.hashCode();
    }
}

