/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.simplifier.ExternalSimplifier;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class SymbolicValueFormula
implements Value {
    ExpressionBase root;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicValueFormula other = (SymbolicValueFormula)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public ExpressionBase getRoot() {
        return this.root;
    }

    public SymbolicValueFormula(ExpressionBase root) {
        this.root = root;
    }

    public Value simplify(LogManagerWithoutDuplicates logger) {
        ExpressionBase simplifiedTree = this.root;
        if (this.root instanceof BinaryExpression && this.isIntegerAddMultiplyOnly()) {
            simplifiedTree = ExternalSimplifier.simplify(simplifiedTree, logger);
        }
        if (simplifiedTree instanceof ConstantValue) {
            return ((ConstantValue)simplifiedTree).getValue();
        }
        return new SymbolicValueFormula(simplifiedTree);
    }

    public static ExpressionBase expressionFromExplicitValue(Value value) {
        if (value instanceof SymbolicValueFormula) {
            return ((SymbolicValueFormula)value).root;
        }
        return new ConstantValue(value);
    }

    public Value replaceSymbolWith(SymbolicValue pSymbol, Value pReplacement, LogManagerWithoutDuplicates logger) {
        ConstantValue replacement = new ConstantValue(pReplacement);
        SymbolicValueFormula rval = new SymbolicValueFormula(this.root.replaceSymbolWith(pSymbol, replacement));
        if (!rval.root.equals(this.root)) {
            return rval.simplify(logger);
        }
        return this;
    }

    public Pair<SymbolicValue, Value> inferAssignment(boolean truthValue, LogManagerWithoutDuplicates logger) {
        Set<SymbolicValue> symbolicValues = this.root.getSymbolicValues();
        ExpressionBase root = this.root;
        if (symbolicValues.size() != 1) {
            return null;
        }
        SymbolicValue valueToSolveFor = symbolicValues.iterator().next();
        if (root instanceof BinaryExpression) {
            BinaryExpression rootBinaryExpression = (BinaryExpression)root;
            String operator = rootBinaryExpression.getOperator().op;
            if (operator.equals("!=") && !truthValue) {
                root = new BinaryExpression(rootBinaryExpression.getOperand1(), rootBinaryExpression.getOperand2(), BinaryExpression.BinaryOperator.EQUALS, rootBinaryExpression.getCalculationType(), rootBinaryExpression.getResultType());
                operator = "==";
                truthValue = true;
            }
            if (operator.equals("==") && truthValue) {
                if (rootBinaryExpression.lVal instanceof SymbolicValue && rootBinaryExpression.rVal instanceof ConstantValue) {
                    SymbolicValue symbol = (SymbolicValue)rootBinaryExpression.lVal;
                    ConstantValue value = (ConstantValue)rootBinaryExpression.rVal;
                    return Pair.of((Object)symbol, (Object)value.getValue());
                }
                if (rootBinaryExpression.rVal instanceof SymbolicValue && rootBinaryExpression.lVal instanceof ConstantValue) {
                    SymbolicValue symbol = (SymbolicValue)rootBinaryExpression.rVal;
                    ConstantValue value = (ConstantValue)rootBinaryExpression.lVal;
                    return Pair.of((Object)symbol, (Object)value.getValue());
                }
                Value result = ExternalSimplifier.solve(valueToSolveFor, root, logger);
                if (result == null) {
                    return null;
                }
                return Pair.of((Object)valueToSolveFor, (Object)result);
            }
        }
        return null;
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return false;
    }

    @Override
    public NumericValue asNumericValue() {
        return null;
    }

    @Override
    public Long asLong(CType pType) {
        Preconditions.checkNotNull((Object)pType);
        return null;
    }

    public String toString() {
        return "SymbolicValueFormula {" + this.root.toString() + "}";
    }

    public boolean isIntegerAddMultiplyOnly() {
        return this.root.isIntegerAddMultiplyOnly();
    }

    public static class ConstantValue
    implements ExpressionBase {
        private Value value;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantValue other = (ConstantValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public Value getValue() {
            return this.value;
        }

        public ConstantValue(Value value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public boolean isIntegerAddMultiplyOnly() {
            return true;
        }

        @Override
        public ExpressionBase replaceSymbolWith(SymbolicValue pSymbol, ConstantValue pReplacement) {
            return this;
        }

        @Override
        public Set<SymbolicValue> getSymbolicValues() {
            return new HashSet<SymbolicValue>();
        }
    }

    public static class SymbolicValue
    implements ExpressionBase {
        private String displayName;

        public SymbolicValue(String name) {
            this.displayName = name;
        }

        @Override
        public boolean isIntegerAddMultiplyOnly() {
            return true;
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public ExpressionBase replaceSymbolWith(SymbolicValue pSymbol, ConstantValue pReplacement) {
            if (this.equals(pSymbol)) {
                return pReplacement;
            }
            return this;
        }

        @Override
        public Set<SymbolicValue> getSymbolicValues() {
            HashSet<SymbolicValue> rval = new HashSet<SymbolicValue>();
            rval.add(this);
            return rval;
        }
    }

    public static class BinaryExpression
    implements ExpressionBase {
        private ExpressionBase lVal;
        private ExpressionBase rVal;
        private CType resultType;
        private CType calculationType;
        private BinaryOperator op;

        public CType getResultType() {
            return this.resultType;
        }

        public CType getCalculationType() {
            return this.calculationType;
        }

        public ExpressionBase getOperand1() {
            return this.lVal;
        }

        public ExpressionBase getOperand2() {
            return this.rVal;
        }

        public BinaryOperator getOperator() {
            return this.op;
        }

        public BinaryExpression(ExpressionBase lVal, ExpressionBase rVal, BinaryOperator op, CType resultType, CType calculationType) {
            this.lVal = lVal;
            this.rVal = rVal;
            this.op = op;
            this.resultType = resultType;
            this.calculationType = calculationType;
        }

        public String toString() {
            return this.lVal.toString() + " " + this.op.toString() + " " + this.rVal.toString();
        }

        @Override
        public boolean isIntegerAddMultiplyOnly() {
            ArrayList<String> allowedOps = new ArrayList<String>();
            allowedOps.add("PLUS");
            allowedOps.add("MINUS");
            allowedOps.add("MULTIPLY");
            if (!allowedOps.contains(this.op.toString())) {
                return false;
            }
            CSimpleType arithmeticType = AbstractExpressionValueVisitor.getArithmeticType(this.resultType);
            return arithmeticType.getType() == CBasicType.INT && this.lVal.isIntegerAddMultiplyOnly() && this.rVal.isIntegerAddMultiplyOnly();
        }

        @Override
        public ExpressionBase replaceSymbolWith(SymbolicValue pSymbol, ConstantValue pReplacement) {
            ExpressionBase leftHand = this.lVal.replaceSymbolWith(pSymbol, pReplacement);
            ExpressionBase rightHand = this.rVal.replaceSymbolWith(pSymbol, pReplacement);
            return new BinaryExpression(leftHand, rightHand, this.op, this.resultType, this.calculationType);
        }

        @Override
        public Set<SymbolicValue> getSymbolicValues() {
            Set<SymbolicValue> leftHand = this.lVal.getSymbolicValues();
            Set<SymbolicValue> rightHand = this.rVal.getSymbolicValues();
            leftHand.addAll(rightHand);
            return leftHand;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lVal == null ? 0 : this.lVal.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.rVal == null ? 0 : this.rVal.hashCode());
            result = 31 * result + (this.resultType == null ? 0 : this.resultType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinaryExpression other = (BinaryExpression)obj;
            if (this.lVal == null ? other.lVal != null : !this.lVal.equals(other.lVal)) {
                return false;
            }
            if (this.op != other.op) {
                return false;
            }
            if (this.rVal == null ? other.rVal != null : !this.rVal.equals(other.rVal)) {
                return false;
            }
            return !(this.resultType == null ? other.resultType != null : !this.resultType.equals(other.resultType));
        }

        public static enum BinaryOperator {
            MULTIPLY("*"),
            DIVIDE("/"),
            MODULO("%"),
            PLUS("+"),
            MINUS("-"),
            SHIFT_LEFT("<<"),
            SHIFT_RIGHT(">>"),
            LESS_THAN("<"),
            GREATER_THAN(">"),
            LESS_EQUAL("<="),
            GREATER_EQUAL(">="),
            BINARY_AND("&"),
            BINARY_XOR("^"),
            BINARY_OR("|"),
            EQUALS("=="),
            NOT_EQUALS("!=");

            private final String op;

            private BinaryOperator(String pOp) {
                this.op = pOp;
            }

            public static BinaryOperator fromString(String key) {
                for (BinaryOperator iter : BinaryOperator.values()) {
                    if (!iter.op.equals(key)) continue;
                    return iter;
                }
                return null;
            }
        }
    }

    public static interface ExpressionBase {
        public boolean isIntegerAddMultiplyOnly();

        public ExpressionBase replaceSymbolWith(SymbolicValue var1, ConstantValue var2);

        public Set<SymbolicValue> getSymbolicValues();
    }
}

