/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type.symbolic;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.symbolic.SymbolicFormula;
import org.sosy_lab.cpachecker.cpa.value.type.symbolic.SymbolicIdentifier;

public class SymbolicValueFactory {
    private static final SymbolicValueFactory INSTANCE = new SymbolicValueFactory();
    private static final String NO_SYMBOLIC_VALUE_ERROR = "Don't create a symbolic formula if you can just compute the expression's value!";

    private SymbolicValueFactory() {
    }

    public static SymbolicValueFactory getInstance() {
        return INSTANCE;
    }

    public SymbolicValue createIdentifier(Type pType) {
        return SymbolicIdentifier.getInstance(pType);
    }

    public SymbolicValue createAddition(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.add(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    private InvariantsFormula<Value> getFormulaOperand(Value pValue) {
        if (pValue instanceof SymbolicFormula) {
            return ((SymbolicFormula)pValue).getFormula();
        }
        return this.getConstant(pValue);
    }

    public SymbolicValue createMultiplication(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.multiply(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createDivision(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.divide(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createModulo(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.modulo(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createShiftLeft(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.shiftLeft(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createShiftRight(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.shiftRight(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createBinaryOr(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.binaryOr(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createBinaryAnd(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.binaryAnd(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createBinaryXor(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.binaryXor(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createBinaryNot(Value pOperand, Type pOperandType) {
        assert (pOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.binaryNot(this.getFormulaOperand(pOperand));
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createEquals(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.equal(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createGreaterThan(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.greaterThan(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createGreaterThanOrEqual(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.greaterThanOrEqual(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createLessThan(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.lessThan(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createLessThanOrEqual(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.lessThanOrEqual(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createConditionalAnd(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.logicalAnd(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createConditionalOr(Value pLeftOperand, Type pLeftType, Value pRightOperand, Type pRightType) {
        assert (pLeftOperand instanceof SymbolicValue || pRightOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> leftFormulaOperand = this.getFormulaOperand(pLeftOperand);
        InvariantsFormula<Value> rightFormulaOperand = this.getFormulaOperand(pRightOperand);
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.logicalOr(leftFormulaOperand, rightFormulaOperand);
        return new SymbolicFormula(formula);
    }

    public SymbolicValue createLogicalNot(Value pOperand, Type pOperandType) {
        assert (pOperand instanceof SymbolicValue) : "Don't create a symbolic formula if you can just compute the expression's value!";
        InvariantsFormula<Value> formula = InvariantsFormulaManager.INSTANCE.logicalNot(this.getFormulaOperand(pOperand));
        return new SymbolicFormula(formula);
    }

    private InvariantsFormula<Value> getConstant(Value pValue) {
        Preconditions.checkNotNull((Object)pValue);
        return InvariantsFormulaManager.INSTANCE.asConstant(pValue);
    }
}

