/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.wp;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.wp.WpAbstractDomain;
import org.sosy_lab.cpachecker.cpa.wp.WpMergeOperator;
import org.sosy_lab.cpachecker.cpa.wp.WpTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;

@Options
public class WpCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
AutoCloseable {
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final TransferRelation transfer;
    private final PrecisionAdjustment prec;
    private final WpAbstractDomain domain;
    private final MergeOperator merge;
    private final StopOperator stop;
    private final Solver solver;
    private final RegionManager regionManager;
    private final AbstractionManager abstractionManager;
    private final PredicateAbstractionManager predicateManager;
    private final PathFormulaManager pathFormulaManager;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(WpCPA.class);
    }

    protected WpCPA(Configuration pConfig, LogManager pLogger, CFA pCfa, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, CPAException {
        pConfig.inject((Object)this, WpCPA.class);
        this.config = pConfig;
        this.logger = pLogger;
        this.cfa = pCfa;
        this.solver = Solver.create(pConfig, pLogger, pShutdownNotifier);
        FormulaManagerView formulaManager = this.solver.getFormulaManager();
        this.pathFormulaManager = new PathFormulaManagerImpl(formulaManager, this.config, this.logger, pShutdownNotifier, this.cfa, AnalysisDirection.BACKWARD);
        this.regionManager = new BDDManagerFactory(this.config, this.logger).createRegionManager();
        this.abstractionManager = new AbstractionManager(this.regionManager, formulaManager, this.config, this.logger);
        this.predicateManager = new PredicateAbstractionManager(this.abstractionManager, formulaManager, this.pathFormulaManager, this.solver, this.config, this.logger, this.cfa.getLiveVariables());
        this.transfer = new WpTransferRelation(this.config, this.logger, this.pathFormulaManager, formulaManager, this.solver);
        this.domain = new WpAbstractDomain(this.pathFormulaManager, formulaManager);
        this.prec = StaticPrecisionAdjustment.getInstance();
        this.merge = new WpMergeOperator(this.domain);
        this.stop = new StopSepOperator(this.domain);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.prec;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.domain.getTopInstance();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public void close() throws Exception {
        this.solver.close();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
    }
}

