/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class RefinementFailedException
extends CPAException {
    private static final long serialVersionUID = 2353178323706458175L;
    private ARGPath path;

    public RefinementFailedException(Reason r, @Nullable ARGPath p) {
        super(RefinementFailedException.getMessage(r, null));
        this.path = p;
    }

    public RefinementFailedException(Reason r, @Nullable ARGPath p, Throwable t) {
        super(RefinementFailedException.getMessage(r, t), (Throwable)Preconditions.checkNotNull((Object)t));
        this.path = p;
    }

    private static String getMessage(Reason r, @Nullable Throwable t) {
        String msg;
        StringBuilder sb = new StringBuilder();
        sb.append("Refinement failed: ");
        sb.append(r.toString());
        if (t != null && !(msg = Strings.nullToEmpty((String)t.getMessage())).isEmpty()) {
            sb.append(" (");
            sb.append(msg);
            sb.append(")");
        }
        return sb.toString();
    }

    @Nullable
    public ARGPath getErrorPath() {
        return this.path;
    }

    public void setErrorPath(ARGPath pPath) {
        this.path = (ARGPath)Preconditions.checkNotNull((Object)pPath);
    }

    public static enum Reason {
        InterpolationFailed("Interpolation failed"),
        InvariantRefinementFailed("Could not find invariant"),
        RepeatedCounterexample("Counterexample could not be ruled out and was found again"),
        TooMuchUnrolling("Too much unrolling"),
        InfeasibleCounterexample("External tool verified counterexample as infeasible"),
        TIMEOUT("SMT-solver timed out");

        private final String humanReableReason;

        private Reason(String pHumanReableReason) {
            this.humanReableReason = pHumanReableReason;
        }

        public String toString() {
            return this.humanReableReason;
        }
    }
}

