/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class UnrecognizedCFAEdgeException
extends CPATransferException {
    private static final long serialVersionUID = -5106215499745787051L;

    public UnrecognizedCFAEdgeException(CFAEdge edge) {
        super(UnrecognizedCFAEdgeException.createMessage(edge));
    }

    private static String createMessage(CFAEdge edge) {
        if (edge.getEdgeType() == CFAEdgeType.MultiEdge) {
            return "Some CPAs do not support MultiEdges. Please set the configuration option \"cfa.useMultiEdges\" to \"false\".";
        }
        return "Unknown CFA edge: " + (Object)((Object)edge.getEdgeType()) + " (" + edge.getDescription() + ")";
    }
}

