/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.propertychecker;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;

public class PropertyCheckerBuilder {
    private static final String PROPERTYCHECKER_CLASS_PREFIX = "org.sosy_lab.cpachecker.pcc.propertychecker";

    public static PropertyChecker buildPropertyChecker(String propCheckerClassName, String pCheckerParamList) throws InvalidConfigurationException {
        String[] param;
        Class propertyCheckerClass;
        if (propCheckerClassName == null) {
            throw new InvalidConfigurationException("No property checker defined.");
        }
        try {
            propertyCheckerClass = Classes.forName((String)propCheckerClassName, (String)PROPERTYCHECKER_CLASS_PREFIX);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Class for property checker  " + propCheckerClassName + " is unknown.", (Throwable)e);
        }
        if (!PropertyChecker.class.isAssignableFrom(propertyCheckerClass)) {
            throw new InvalidConfigurationException("Option propertychecker.className must be set to a class implementing the PropertyChecker interface!");
        }
        if (pCheckerParamList.equals("")) {
            param = new String[]{};
        } else {
            String[] result = pCheckerParamList.split(",", -1);
            param = new String[result.length - 1];
            for (int i = 0; i < param.length; ++i) {
                param[i] = result[i];
            }
        }
        try {
            Constructor<?>[] cons = propertyCheckerClass.getConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> con : cons) {
                Class<?>[] paramTypes = con.getParameterTypes();
                if (paramTypes.length != param.length) continue;
                for (Class<?> paramType : paramTypes) {
                    if (paramType == String.class) continue;
                }
                constructor = con;
                break;
            }
            if (constructor == null) {
                throw new UnsupportedOperationException("Cannot create PropertyChecker " + propCheckerClassName + " if it does not provide a constructor with " + param.length + " String parameters.");
            }
            return (PropertyChecker)constructor.newInstance(param);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Creation of specified PropertyChecker instance failed.", e);
        }
    }
}

