/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.propertychecker.NoTargetStateChecker;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractARGStrategy;

@Options
public class ARGProofCheckerStrategy
extends AbstractARGStrategy {
    private final ProofChecker checker;
    private Set<ARGState> postponedStates;
    private Set<ARGState> waitingForUnexploredParents;
    private Set<ARGState> inWaitlist;

    public ARGProofCheckerStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ProofChecker pChecker) throws InvalidConfigurationException {
        super(pConfig, pLogger, pChecker instanceof PropertyCheckerCPA ? ((PropertyCheckerCPA)((Object)pChecker)).getPropChecker() : new NoTargetStateChecker(), pShutdownNotifier);
        this.checker = pChecker;
    }

    @Override
    protected void initChecking(ARGState pRoot) {
        this.postponedStates = new HashSet<ARGState>();
        this.waitingForUnexploredParents = new HashSet<ARGState>();
        this.inWaitlist = new HashSet<ARGState>();
        this.inWaitlist.add(pRoot);
    }

    @Override
    protected boolean checkForStatePropertyAndOtherStateActions(ARGState pState) {
        this.inWaitlist.remove(pState);
        return super.checkForStatePropertyAndOtherStateActions(pState);
    }

    @Override
    protected boolean checkCovering(ARGState pCovered, ARGState pCovering, Precision pPrecision) throws CPAException, InterruptedException {
        return this.checker.isCoveredBy(pCovered, pCovering);
    }

    @Override
    protected boolean isCheckSuccessful() {
        return this.waitingForUnexploredParents.isEmpty();
    }

    @Override
    protected boolean isCheckComplete() {
        return this.postponedStates.isEmpty();
    }

    @Override
    protected boolean prepareNextWaitlistIteration(ReachedSet pReachedSet) {
        for (ARGState e : this.postponedStates) {
            if (!pReachedSet.contains(e.getCoveringState())) {
                this.logger.log(Level.WARNING, new Object[]{"Covering state", e.getCoveringState(), "was not found in reached set"});
                return false;
            }
            pReachedSet.reAddToWaitlist(e);
        }
        this.postponedStates.clear();
        return true;
    }

    @Override
    protected boolean checkSuccessors(ARGState pPredecessor, Collection<ARGState> pSuccessors, Precision pPrecision) throws CPATransferException, InterruptedException {
        return this.checker.areAbstractSuccessors(pPredecessor, null, pSuccessors);
    }

    @Override
    protected boolean addSuccessors(Collection<ARGState> pSuccessors, ReachedSet pReachedSet, Precision pPrecision) {
        for (ARGState e : pSuccessors) {
            boolean unexploredParent = false;
            for (ARGState p : e.getParents()) {
                if (pReachedSet.contains(p) && !this.inWaitlist.contains(p)) continue;
                this.waitingForUnexploredParents.add(e);
                unexploredParent = true;
                break;
            }
            if (unexploredParent) continue;
            if (pReachedSet.contains(e)) {
                this.logger.log(Level.WARNING, new Object[]{"State", e, "has other parents than", e.getParents()});
                return false;
            }
            this.waitingForUnexploredParents.remove(e);
            pReachedSet.add(e, pPrecision);
            this.inWaitlist.add(e);
        }
        return true;
    }

    @Override
    protected boolean treatStateIfCoveredByUnkownState(ARGState pCovered, ARGState pCoveringState, ReachedSet pReachedSet, Precision pPrecision) {
        this.postponedStates.add(pCovered);
        return true;
    }
}

