/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.SequentialReadStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;

public abstract class AbstractARGStrategy
extends SequentialReadStrategy {
    private ARGState root;
    protected final PropertyChecker propChecker;
    private final ShutdownNotifier shutdownNotifier;

    public AbstractARGStrategy(Configuration pConfig, LogManager pLogger, PropertyChecker pPropertyChecker, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        this.propChecker = pPropertyChecker;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached) {
        if (this.correctReachedSetFormatForProof(pReached)) {
            this.root = (ARGState)pReached.getFirstState();
            this.stats.increaseProofSize(1);
        }
    }

    private boolean correctReachedSetFormatForProof(UnmodifiableReachedSet pReached) {
        if (pReached.getFirstState() == null || !(pReached.getFirstState() instanceof ARGState) || AbstractStates.extractLocation(pReached.getFirstState()) == null) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
            return false;
        }
        return true;
    }

    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.initChecking(this.root);
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm started"});
        ARGState initialState = (ARGState)pReachedSet.popFromWaitlist();
        Precision initialPrecision = pReachedSet.getPrecision(initialState);
        this.logger.log(Level.FINE, new Object[]{"Checking root state"});
        if (!this.checkCovering(initialState, this.root, initialPrecision)) {
            return false;
        }
        pReachedSet.add(this.root, initialPrecision);
        do {
            if (!this.prepareNextWaitlistIteration(pReachedSet)) {
                return false;
            }
            while (pReachedSet.hasWaitingState()) {
                this.shutdownNotifier.shutdownIfNecessary();
                ++this.stats.countIterations;
                ARGState state = (ARGState)pReachedSet.popFromWaitlist();
                this.logger.log(Level.FINE, new Object[]{"Looking at state", state});
                if (!this.checkForStatePropertyAndOtherStateActions(state)) {
                    this.logger.log(Level.INFO, new Object[]{"Property violation at state", state});
                    return false;
                }
                if (!(state.isCovered() ? !this.checkCoveredStates(state, pReachedSet, initialPrecision) : !this.checkAndAddSuccessors(state, pReachedSet, initialPrecision))) continue;
                return false;
            }
        } while (!this.isCheckComplete());
        return this.isCheckSuccessful();
    }

    private boolean checkCoveredStates(ARGState pCovered, ReachedSet pReachedSet, Precision pPrecision) throws CPAException, InterruptedException {
        this.logger.log(Level.FINER, new Object[]{"State is covered by another abstract state; checking coverage"});
        ARGState coveringState = pCovered.getCoveringState();
        if (!pReachedSet.contains(coveringState) && this.treatStateIfCoveredByUnkownState(pCovered, coveringState, pReachedSet, pPrecision)) {
            return true;
        }
        this.stats.stopTimer.start();
        if (!this.isCoveringCycleFree(pCovered)) {
            this.stats.stopTimer.stop();
            this.logger.log(Level.WARNING, new Object[]{"Found cycle in covering relation for state", pCovered});
            return false;
        }
        if (!this.checkCovering(pCovered, coveringState, pPrecision)) {
            this.stats.stopTimer.stop();
            this.logger.log(Level.WARNING, new Object[]{"State", pCovered, "is not covered by", coveringState});
            return false;
        }
        this.stats.stopTimer.stop();
        return true;
    }

    private boolean checkAndAddSuccessors(ARGState pPredecessor, ReachedSet pReachedSet, Precision pPrecision) throws InterruptedException, CPAException {
        this.stats.transferTimer.start();
        Collection<ARGState> successors = pPredecessor.getChildren();
        this.logger.log(Level.FINER, new Object[]{"Checking abstract successors", successors});
        if (!this.checkSuccessors(pPredecessor, successors, pPrecision)) {
            this.stats.transferTimer.stop();
            this.logger.log(Level.WARNING, new Object[]{"State", pPredecessor, "has other successors than", successors});
            return false;
        }
        this.stats.transferTimer.stop();
        return this.addSuccessors(successors, pReachedSet, pPrecision);
    }

    @Override
    protected Object getProofToWrite(UnmodifiableReachedSet pReached) {
        this.constructInternalProofRepresentation(pReached);
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareForChecking(Object pReadProof) throws InvalidConfigurationException {
        try {
            this.stats.preparationTimer.start();
            if (!(pReadProof instanceof ARGState)) {
                throw new InvalidConfigurationException("Proof Strategy requires ARG.");
            }
            this.root = (ARGState)pReadProof;
        }
        finally {
            this.stats.preparationTimer.stop();
        }
    }

    private boolean isCoveringCycleFree(ARGState pState) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        seen.add(pState);
        while (pState.isCovered()) {
            boolean isNew = seen.add(pState = pState.getCoveringState());
            if (isNew) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForStatePropertyAndOtherStateActions(ARGState pState) {
        try {
            this.stats.propertyCheckingTimer.start();
            boolean bl = this.propChecker.satisfiesProperty(pState);
            return bl;
        }
        finally {
            this.stats.propertyCheckingTimer.stop();
        }
    }

    protected abstract void initChecking(ARGState var1);

    protected abstract boolean prepareNextWaitlistIteration(ReachedSet var1);

    protected abstract boolean treatStateIfCoveredByUnkownState(ARGState var1, ARGState var2, ReachedSet var3, Precision var4);

    protected abstract boolean checkCovering(ARGState var1, ARGState var2, Precision var3) throws CPAException, InterruptedException;

    protected abstract boolean checkSuccessors(ARGState var1, Collection<ARGState> var2, Precision var3) throws InterruptedException, CPAException;

    protected abstract boolean addSuccessors(Collection<ARGState> var1, ReachedSet var2, Precision var3);

    protected abstract boolean isCheckSuccessful();

    protected abstract boolean isCheckComplete();
}

