/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="pcc")
public abstract class AbstractStrategy
implements PCCStrategy,
StatisticsProvider {
    protected LogManager logger;
    protected PCStrategyStatistics stats;
    private Collection<Statistics> pccStats = new ArrayList<Statistics>();
    @Option(secure=true, name="proofFile", description="file in which proof representation needed for proof checking is stored")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    protected Path file = Paths.get((String)"arg.obj", (String[])new String[0]);
    @Option(secure=true, name="useCores", description="number of cpus/cores which should be used in parallel for proof checking")
    @IntegerOption(min=1L)
    protected int numThreads = 1;

    public AbstractStrategy(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this, AbstractStrategy.class);
        this.numThreads = Math.max(1, this.numThreads);
        this.numThreads = Math.min(Runtime.getRuntime().availableProcessors(), this.numThreads);
        this.logger = pLogger;
        this.stats = new PCStrategyStatistics();
        this.pccStats.add(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProof(UnmodifiableReachedSet pReached) {
        OutputStream fos = null;
        try {
            boolean continueWriting;
            fos = this.file.asByteSink(new FileWriteMode[0]).openStream();
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry("Proof");
            zos.putNextEntry(ze);
            ObjectOutputStream o = new ObjectOutputStream(zos);
            this.writeProofToStream(o, pReached);
            o.flush();
            zos.closeEntry();
            int index = 0;
            do {
                ze = new ZipEntry("Additional " + index);
                zos.putNextEntry(ze);
                o = new ObjectOutputStream(zos);
                continueWriting = this.writeAdditionalProofStream(o);
                o.flush();
                zos.closeEntry();
                ++index;
            } while (continueWriting);
            ze = new ZipEntry("Helper");
            zos.putNextEntry(ze);
            o = new ObjectOutputStream(zos);
            int numberOfStorages = GlobalInfo.getInstance().getNumberOfHelperStorages();
            o.writeInt(numberOfStorages);
            for (int i = 0; i < numberOfStorages; ++i) {
                o.writeObject(GlobalInfo.getInstance().getHelperStorage(i));
            }
            o.flush();
            zos.closeEntry();
            zos.close();
        }
        catch (NotSerializableException eS) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be written. Class " + eS.getMessage() + " does not implement Serializable interface"});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be constructed due to conflicting configuration.", e.getMessage()});
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be written due to time out during proof construction"});
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {}
        }
    }

    protected abstract void writeProofToStream(ObjectOutputStream var1, UnmodifiableReachedSet var2) throws IOException, InvalidConfigurationException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProof() throws IOException, ClassNotFoundException, InvalidConfigurationException {
        try (InputStream fis = null;){
            fis = this.file.asByteSource().openStream();
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            assert (entry.getName().equals("Proof"));
            do {
                zis.closeEntry();
            } while ((entry = zis.getNextEntry()).getName().startsWith("Additional "));
            assert (entry.getName().equals("Helper"));
            ObjectInputStream o = new ObjectInputStream(zis);
            int numberOfStorages = o.readInt();
            for (int i = 0; i < numberOfStorages; ++i) {
                Serializable storage = (Serializable)o.readObject();
                GlobalInfo.getInstance().addHelperStorage(storage);
            }
            zis.closeEntry();
            o.close();
            zis.close();
            fis.close();
            Triple<InputStream, ZipInputStream, ObjectInputStream> proofStream = this.openProofStream();
            this.readProofFromStream((ObjectInputStream)proofStream.getThird());
            ((ObjectInputStream)proofStream.getThird()).close();
            ((ZipInputStream)proofStream.getSecond()).close();
            ((InputStream)proofStream.getFirst()).close();
        }
    }

    protected boolean writeAdditionalProofStream(ObjectOutputStream pOut) throws IOException {
        return false;
    }

    protected Triple<InputStream, ZipInputStream, ObjectInputStream> openProofStream() throws IOException {
        InputStream fis = this.file.asByteSource().openStream();
        ZipInputStream zis = new ZipInputStream(fis);
        ZipEntry entry = zis.getNextEntry();
        assert (entry.getName().equals("Proof"));
        return Triple.of((Object)fis, (Object)zis, (Object)new ObjectInputStream(zis));
    }

    public Triple<InputStream, ZipInputStream, ObjectInputStream> openAdditionalProofStream(int index) throws IOException {
        if (index < 0) {
            throw new IllegalArgumentException("Not a valid index. Indices must be at least zero.");
        }
        InputStream fis = this.file.asByteSource().openStream();
        ZipInputStream zis = new ZipInputStream(fis);
        ZipEntry entry = null;
        for (int i = 0; i <= 1 + index; ++i) {
            entry = zis.getNextEntry();
        }
        assert (entry.getName().equals("Additional " + index));
        return Triple.of((Object)fis, (Object)zis, (Object)new ObjectInputStream(zis));
    }

    protected abstract void readProofFromStream(ObjectInputStream var1) throws ClassNotFoundException, InvalidConfigurationException, IOException;

    protected void addPCCStatistic(Statistics pPCCStatistic) {
        this.pccStats.add(pPCCStatistic);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.addAll(this.pccStats);
    }

    public static class PCStrategyStatistics
    implements Statistics {
        protected Timer transferTimer = new Timer();
        protected Timer stopTimer = new Timer();
        protected Timer preparationTimer = new Timer();
        protected Timer propertyCheckingTimer = new Timer();
        protected int countIterations = 0;
        protected int proofSize = 0;

        @Override
        public String getName() {
            return "Proof Checking Strategy Statistics";
        }

        public Timer getPreparationTimer() {
            return this.preparationTimer;
        }

        public Timer getStopTimer() {
            return this.stopTimer;
        }

        public Timer getTransferTimer() {
            return this.transferTimer;
        }

        public Timer getPropertyCheckingTimer() {
            return this.propertyCheckingTimer;
        }

        public void increaseIteration() {
            ++this.countIterations;
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of iterations:                     " + this.countIterations);
            out.println();
            out.println("Number of proof elements:                     " + this.proofSize);
            out.println();
            out.println("  Time for preparing proof for checking:          " + this.preparationTimer);
            out.println("  Time for abstract successor checks:     " + this.transferTimer + " (Calls: " + this.transferTimer.getNumberOfIntervals() + ")");
            out.println("  Time for covering checks:               " + this.stopTimer + " (Calls: " + this.stopTimer.getNumberOfIntervals() + ")");
            out.println(" Time for checking property:          " + this.propertyCheckingTimer);
        }

        public void increaseProofSize(int pIncrement) {
            this.proofSize += pIncrement;
        }
    }
}

