/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;

public class PCCStrategyBuilder {
    private static final String STRATEGY_CLASS_PREFIX = "org.sosy_lab.cpachecker.pcc.strategy";
    private static final String PARALLEL_STRATEGY_CLASS_PREFIX = "org.sosy_lab.cpachecker.pcc.strategy.parallel";

    public static PCCStrategy buildStrategy(String pPccStrategy, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        Class pccStrategyClass;
        if (pPccStrategy == null) {
            throw new InvalidConfigurationException("No PCC strategy defined.");
        }
        try {
            pccStrategyClass = Classes.forName((String)pPccStrategy, (String)STRATEGY_CLASS_PREFIX);
        }
        catch (ClassNotFoundException e) {
            try {
                pccStrategyClass = Classes.forName((String)pPccStrategy, (String)PARALLEL_STRATEGY_CLASS_PREFIX);
            }
            catch (ClassNotFoundException e1) {
                throw new InvalidConfigurationException("Class for pcc checker  " + pPccStrategy + " is unknown.", (Throwable)e1);
            }
        }
        if (!PCCStrategy.class.isAssignableFrom(pccStrategyClass)) {
            throw new InvalidConfigurationException("Specified class " + pPccStrategy + "does not implement the pPccStrategy interface!");
        }
        try {
            Constructor<?>[] cons;
            for (Constructor<?> con : cons = pccStrategyClass.getConstructors()) {
                Class<?>[] paramTypes = con.getParameterTypes();
                if (paramTypes.length != 4 || paramTypes[0] != Configuration.class || paramTypes[1] != LogManager.class || paramTypes[2] != ShutdownNotifier.class) continue;
                if (pCpa == null) {
                    return (PCCStrategy)con.newInstance(pConfig, pLogger, pShutdownNotifier, pCpa);
                }
                if (paramTypes[3] == ProofChecker.class) {
                    if (!(pCpa instanceof ProofChecker)) continue;
                    return (PCCStrategy)con.newInstance(pConfig, pLogger, pShutdownNotifier, pCpa);
                }
                if (paramTypes[3] != PropertyCheckerCPA.class || !(pCpa instanceof PropertyCheckerCPA)) continue;
                return (PCCStrategy)con.newInstance(pConfig, pLogger, pShutdownNotifier, pCpa);
            }
            throw new UnsupportedOperationException("Cannot create PCC Strategy " + pPccStrategy + " if it does not provide a constructor (Configuration, LogManager, ShutdownNotifier, (PropertyCheckerCPA|ProofChecker)");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Creation of specified PropertyChecker instance failed.", e);
        }
    }
}

