/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningCheckingHelper;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;

public class ParallelPartitionChecker
implements Runnable,
PartitioningCheckingHelper {
    private final AtomicInteger numPartitionsAcquiredForChecking;
    private final AtomicInteger nextPartition;
    private final AtomicBoolean checkResult;
    private final Semaphore readAndUnprocessedPartitions;
    private final Semaphore checkedPartitions;
    private final Lock mutex;
    private final PartitioningIOHelper ioHelper;
    private final PartitionChecker checker;
    private final Collection<AbstractState> certificate;
    private final Multimap<CFANode, AbstractState> partitionElems;
    private final Collection<AbstractState> inOtherPartition;
    private final ShutdownNotifier shutdownNotifier;

    public ParallelPartitionChecker(AtomicInteger pAvailablePartitions, AtomicInteger pNextId, AtomicBoolean pCheckResult, Semaphore pReadButUnprocessed, Semaphore pPartitionsChecked, Lock pMutex, PartitioningIOHelper pIOHelper, Multimap<CFANode, AbstractState> partitionElements, Collection<AbstractState> pCertificate, Collection<AbstractState> pInOtherPartition, Precision init, StopOperator stop, TransferRelation transfer, ShutdownNotifier pShutdownNotifier, LogManager pLogger) {
        this.numPartitionsAcquiredForChecking = pAvailablePartitions;
        this.nextPartition = pNextId;
        this.checkResult = pCheckResult;
        this.readAndUnprocessedPartitions = pReadButUnprocessed;
        this.checkedPartitions = pPartitionsChecked;
        this.mutex = pMutex;
        this.ioHelper = pIOHelper;
        this.certificate = pCertificate;
        this.partitionElems = partitionElements;
        this.inOtherPartition = pInOtherPartition;
        this.shutdownNotifier = pShutdownNotifier;
        this.checker = new PartitionChecker(init, stop, transfer, this.ioHelper, this, pShutdownNotifier, pLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.numPartitionsAcquiredForChecking.incrementAndGet() <= this.ioHelper.getNumPartitions()) {
            if (this.shutdownNotifier.shouldShutdown()) {
                this.abortCheckingPreparation();
            }
            if (!this.checkResult.get()) break;
            try {
                this.readAndUnprocessedPartitions.acquire();
            }
            catch (InterruptedException e) {
                this.abortCheckingPreparation();
                return;
            }
            int nextPartitionId = this.nextPartition.getAndIncrement();
            if (!this.checkResult.get()) break;
            if (this.shutdownNotifier.shouldShutdown()) {
                this.abortCheckingPreparation();
            }
            this.checker.checkPartition(nextPartitionId);
            this.mutex.lock();
            try {
                this.checker.addCertificatePartsToCertificate(this.certificate);
                this.checker.addPartitionElements(this.partitionElems);
                this.checker.addElementsCheckedInOtherPartitions(this.inOtherPartition);
            }
            finally {
                this.mutex.unlock();
            }
            this.checkedPartitions.release();
            this.checker.clearAllSavedPartitioningElements();
        }
    }

    @Override
    public int getCurrentCertificateSize() {
        return this.certificate.size();
    }

    @Override
    public void abortCheckingPreparation() {
        this.checkResult.set(false);
        this.readAndUnprocessedPartitions.release(this.ioHelper.getNumPartitions());
        this.checkedPartitions.release(this.ioHelper.getNumPartitions());
    }
}

