/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.ParallelPartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;

public class PartialReachedSetPartitioningParallelStrategy
extends AbstractStrategy {
    private final PartitioningIOHelper ioHelper;
    private final PropertyCheckerCPA cpa;
    private final ShutdownNotifier shutdownNotifier;

    public PartialReachedSetPartitioningParallelStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        this.shutdownNotifier = pShutdownNotifier;
        this.cpa = pCpa;
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier, pCpa);
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached) throws InvalidConfigurationException, InterruptedException {
        this.ioHelper.constructInternalProofRepresentation(pReached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        AtomicBoolean checkResult = new AtomicBoolean(true);
        AtomicInteger availablePartitions = new AtomicInteger(0);
        AtomicInteger nextId = new AtomicInteger(0);
        Semaphore partitionChecked = new Semaphore(0);
        Semaphore readButUnprocessed = new Semaphore(this.ioHelper.getNumPartitions());
        ReentrantLock lock = new ReentrantLock();
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getNumPartitions());
        HashMultimap partitionNodes = HashMultimap.create();
        ArrayList<AbstractState> inOtherPartition = new ArrayList<AbstractState>();
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        this.logger.log(Level.INFO, new Object[]{"Create and start threads"});
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        try {
            boolean bl;
            for (int i = 0; i < this.numThreads; ++i) {
                executor.execute(new ParallelPartitionChecker(availablePartitions, nextId, checkResult, readButUnprocessed, partitionChecked, lock, this.ioHelper, (Multimap<CFANode, AbstractState>)partitionNodes, certificate, inOtherPartition, initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.shutdownNotifier, this.logger));
            }
            partitionChecked.acquire(this.ioHelper.getNumPartitions());
            if (!checkResult.get()) {
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
            inOtherPartition.add(initialState);
            this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
            if (!PartitionChecker.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
                this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Check property."});
            this.stats.getPropertyCheckingTimer().start();
            try {
                if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                    bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
            bl = true;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached) throws IOException, InvalidConfigurationException, InterruptedException {
        this.ioHelper.writeProof(pOut, pReached);
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readProof(pIn, this.stats);
    }
}

