/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.interleaved;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningCheckingHelper;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;

public class PartialReachedSetIOCheckingOnlyInterleavedStrategy
extends AbstractStrategy {
    private final PartitioningIOHelper ioHelper;
    private final PropertyCheckerCPA cpa;
    private final ShutdownNotifier shutdownNotifier;

    public PartialReachedSetIOCheckingOnlyInterleavedStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier, pCpa);
        this.cpa = pCpa;
        this.shutdownNotifier = pShutdownNotifier;
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached) throws InvalidConfigurationException, InterruptedException {
        throw new InvalidConfigurationException("Interleaved proof reading and checking strategies do not  support internal PCC with result check algorithm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        final AtomicBoolean checkResult = new AtomicBoolean(true);
        Semaphore partitionsAvailable = new Semaphore(0);
        HashMultimap partitionNodes = HashMultimap.create();
        HashSet<AbstractState> inOtherPartition = new HashSet<AbstractState>();
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getSavedReachedSetSize());
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        this.logger.log(Level.INFO, new Object[]{"Create reading thread"});
        Thread readingThread = new Thread(new PartitionReader(checkResult, partitionsAvailable));
        try {
            boolean bl;
            readingThread.start();
            PartitioningCheckingHelper checkInfo = new PartitioningCheckingHelper(){

                @Override
                public int getCurrentCertificateSize() {
                    return 0;
                }

                @Override
                public void abortCheckingPreparation() {
                    checkResult.set(false);
                }
            };
            PartitionChecker checker = new PartitionChecker(initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.ioHelper, checkInfo, this.shutdownNotifier, this.logger);
            for (int i = 0; i < this.ioHelper.getNumPartitions() && checkResult.get(); ++i) {
                partitionsAvailable.acquire();
                if (!checkResult.get()) {
                    boolean bl2 = false;
                    return bl2;
                }
                checker.checkPartition(i);
                checker.addCertificatePartsToCertificate(certificate);
                checker.clearPartitionElementsSavedForInspection();
            }
            if (!checkResult.get()) {
                bl = false;
                return bl;
            }
            checker.addPartitionElements((Multimap<CFANode, AbstractState>)partitionNodes);
            checker.addElementsCheckedInOtherPartitions(inOtherPartition);
            this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
            inOtherPartition.add(initialState);
            this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
            if (!PartitionChecker.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
                this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Check property."});
            this.stats.getPropertyCheckingTimer().start();
            try {
                if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                    bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
            bl = true;
            return bl;
        }
        finally {
            checkResult.set(false);
            readingThread.interrupt();
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached) throws IOException, InvalidConfigurationException, InterruptedException {
        Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> partitioning = this.ioHelper.computePartialReachedSetAndPartition(pReached);
        this.ioHelper.writeMetadata(pOut, pReached.size(), ((List)partitioning.getSecond()).size());
        for (Set partition : (List)partitioning.getSecond()) {
            this.ioHelper.writePartition(pOut, partition, (PartialReachedSetDirectedGraph)partitioning.getFirst());
        }
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readMetadata(pIn, true);
    }

    private class PartitionReader
    implements Runnable {
        private final AtomicBoolean checkResult;
        private final Semaphore mainSemaphore;

        public PartitionReader(AtomicBoolean pCheckResult, Semaphore pPartitionChecked) {
            this.checkResult = pCheckResult;
            this.mainSemaphore = pPartitionChecked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Triple streams = null;
            try {
                streams = PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.openProofStream();
                ObjectInputStream o = (ObjectInputStream)streams.getThird();
                PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.ioHelper.readMetadata(o, false);
                for (int i = 0; i < PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.ioHelper.getNumPartitions() && this.checkResult.get(); ++i) {
                    PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.ioHelper.readPartition(o, PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.stats);
                    if (PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.shutdownNotifier.shouldShutdown()) {
                        this.abortPreparation();
                        break;
                    }
                    this.mainSemaphore.release();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.logger.logUserException(Level.SEVERE, (Throwable)e, "Partition reading failed. Stop checking");
                this.abortPreparation();
            }
            catch (Exception e2) {
                PartialReachedSetIOCheckingOnlyInterleavedStrategy.this.logger.logException(Level.SEVERE, (Throwable)e2, "Unexpected failure during proof reading");
                this.abortPreparation();
            }
            finally {
                if (streams != null) {
                    try {
                        ((ObjectInputStream)streams.getThird()).close();
                        ((ZipInputStream)streams.getSecond()).close();
                        ((InputStream)streams.getFirst()).close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private void abortPreparation() {
            this.checkResult.set(false);
            this.mainSemaphore.release();
        }
    }
}

