/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;

public class ParallelPartitionReader
implements Runnable {
    private final AtomicBoolean success;
    private final Semaphore waitRead;
    private final Semaphore partitionChecked;
    private final AtomicInteger nextPartition;
    private final AbstractStrategy strategy;
    private final PartitioningIOHelper ioHelper;
    private final AbstractStrategy.PCStrategyStatistics stats;
    private final LogManager logger;
    private static final Lock lock = new ReentrantLock();

    public ParallelPartitionReader(AtomicBoolean isSuccess, Semaphore partitionsRead, Semaphore pPartitionChecked, AtomicInteger nextPartitionId, AbstractStrategy proofReader, PartitioningIOHelper pIOHelper, AbstractStrategy.PCStrategyStatistics pStats, LogManager pLogger) {
        this.success = isSuccess;
        this.waitRead = partitionsRead;
        this.partitionChecked = pPartitionChecked;
        this.nextPartition = nextPartitionId;
        this.strategy = proofReader;
        this.ioHelper = pIOHelper;
        this.stats = pStats;
        this.logger = pLogger;
    }

    public ParallelPartitionReader(AtomicBoolean isSuccess, Semaphore partitionsRead, AtomicInteger nextPartitionId, AbstractStrategy proofReader, PartitioningIOHelper pIOHelper, AbstractStrategy.PCStrategyStatistics pStats, LogManager pLogger) {
        this(isSuccess, partitionsRead, null, nextPartitionId, proofReader, pIOHelper, pStats, pLogger);
    }

    private void prepareAbortion() {
        this.success.set(false);
        this.waitRead.release(this.ioHelper.getNumPartitions());
        if (this.partitionChecked != null) {
            this.partitionChecked.release(this.ioHelper.getNumPartitions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nextId;
        Triple<InputStream, ZipInputStream, ObjectInputStream> streams = null;
        while ((nextId = this.nextPartition.getAndIncrement()) < this.ioHelper.getNumPartitions()) {
            try {
                streams = this.strategy.openAdditionalProofStream(nextId);
                this.ioHelper.readPartition((ObjectInputStream)streams.getThird(), this.stats, lock);
                this.waitRead.release();
            }
            catch (IOException | ClassNotFoundException e) {
                this.logger.logUserException(Level.SEVERE, (Throwable)e, "Partition reading failed. Stop checking");
                this.prepareAbortion();
            }
            catch (Exception e2) {
                this.logger.logException(Level.SEVERE, (Throwable)e2, "Unexpected failure during proof reading");
                this.prepareAbortion();
            }
            finally {
                if (streams == null) continue;
                try {
                    ((ObjectInputStream)streams.getThird()).close();
                    ((ZipInputStream)streams.getSecond()).close();
                    ((InputStream)streams.getFirst()).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

