/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.io;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.ParallelPartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.io.ParallelPartitionReader;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;

@Options(prefix="pcc.parallel.io")
public class PartialReachedSetParallelReadingStrategy
extends AbstractStrategy {
    private final PartitioningIOHelper ioHelper;
    private final PropertyCheckerCPA cpa;
    private final ShutdownNotifier shutdownNotifier;
    private final Lock lock = new ReentrantLock();
    @Option(secure=true, description="enables parallel checking of partial certificate")
    private boolean enableParallelCheck = false;
    private int nextPartition;

    public PartialReachedSetParallelReadingStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        pConfig.inject((Object)this);
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier, pCpa);
        this.shutdownNotifier = pShutdownNotifier;
        this.cpa = pCpa;
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached) throws InvalidConfigurationException, InterruptedException {
        this.ioHelper.constructInternalProofRepresentation(pReached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        AtomicBoolean checkResult = new AtomicBoolean(true);
        AtomicInteger availablePartitions = new AtomicInteger(0);
        AtomicInteger id = new AtomicInteger(0);
        Semaphore partitionChecked = new Semaphore(0);
        Semaphore readPartitions = new Semaphore(this.ioHelper.getNumPartitions());
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getNumPartitions());
        HashMultimap partitionNodes = HashMultimap.create();
        ArrayList<AbstractState> inOtherPartition = new ArrayList<AbstractState>();
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        this.logger.log(Level.INFO, new Object[]{"Create and start threads"});
        int threads = this.enableParallelCheck ? this.numThreads : 1;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            boolean bl;
            for (int i = 0; i < threads; ++i) {
                executor.execute(new ParallelPartitionChecker(availablePartitions, id, checkResult, readPartitions, partitionChecked, this.lock, this.ioHelper, (Multimap<CFANode, AbstractState>)partitionNodes, certificate, inOtherPartition, initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.shutdownNotifier, this.logger));
            }
            partitionChecked.acquire(this.ioHelper.getNumPartitions());
            if (!checkResult.get()) {
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
            inOtherPartition.add(initialState);
            this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
            if (!PartitionChecker.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
                this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Check property."});
            this.stats.getPropertyCheckingTimer().start();
            try {
                if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                    bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
            bl = true;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached) throws IOException, InvalidConfigurationException, InterruptedException {
        this.ioHelper.constructInternalProofRepresentation(pReached);
        this.ioHelper.writeMetadata(pOut, pReached.size(), this.ioHelper.getNumPartitions());
        this.nextPartition = 0;
    }

    @Override
    protected boolean writeAdditionalProofStream(ObjectOutputStream pOut) throws IOException {
        this.ioHelper.writePartition(pOut, this.ioHelper.getPartition(this.nextPartition));
        ++this.nextPartition;
        return this.nextPartition < this.ioHelper.getNumPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readMetadata(pIn, true);
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        try {
            AtomicBoolean success = new AtomicBoolean(true);
            AtomicInteger nextId = new AtomicInteger(0);
            Semaphore waitRead = new Semaphore(0);
            int numPartition = this.ioHelper.getNumPartitions();
            for (int i = 0; i < this.numThreads; ++i) {
                executor.execute(new ParallelPartitionReader(success, waitRead, nextId, this, this.ioHelper, this.stats, this.logger));
            }
            try {
                waitRead.acquire(numPartition);
            }
            catch (InterruptedException e) {
                throw new IOException("Proof reading failed.");
            }
            if (!success.get()) {
                this.logger.log(Level.SEVERE, new Object[]{"Reading partition from proof failed."});
                throw new IOException("Reading one of the partitions failed");
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

