/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartialReachedConstructionAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.ARGBasedPartialReachedSetConstructionAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.CompleteCertificateConstructionAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.HeuristicPartialReachedSetConstructionAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm;

@Options(prefix="pcc.partial")
public class PartialCertificateTypeProvider {
    @Option(secure=true, description="Selects the strategy used for partial certificate construction")
    private PartialCertificateTypes certificateType = PartialCertificateTypes.HEURISTIC;

    public PartialCertificateTypeProvider(Configuration pConfig, boolean pHeuristicAllowed) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        if (!pHeuristicAllowed && this.certificateType == PartialCertificateTypes.HEURISTIC) {
            this.certificateType = PartialCertificateTypes.ARG;
        }
    }

    public PartialReachedConstructionAlgorithm getPartialCertificateConstructor() {
        return this.getPartialCertificateConstructor(false);
    }

    private PartialReachedConstructionAlgorithm getPartialCertificateConstructor(boolean pKeepARGState) {
        switch (this.certificateType) {
            case ARG: {
                return new ARGBasedPartialReachedSetConstructionAlgorithm(pKeepARGState);
            }
            case MONOTONESTOPARG: {
                return new MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm(pKeepARGState);
            }
        }
        return new HeuristicPartialReachedSetConstructionAlgorithm();
    }

    public PartialReachedConstructionAlgorithm getCertificateConstructor() {
        if (this.certificateType == PartialCertificateTypes.ALL) {
            return new CompleteCertificateConstructionAlgorithm();
        }
        return this.getPartialCertificateConstructor(true);
    }

    public static enum PartialCertificateTypes {
        ALL,
        HEURISTIC,
        ARG,
        MONOTONESTOPARG;

    }
}

