/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.AbstractARGPass;

public class PartialReachedSetDirectedGraph {
    private final AbstractState[] nodes;
    private final int numNodes;
    private final ImmutableList<ImmutableList<Integer>> adjacencyList;

    public PartialReachedSetDirectedGraph(ARGState[] pNodes) {
        ArrayList<List<Integer>> adjacencyList;
        if (pNodes == null) {
            this.nodes = new AbstractState[0];
            this.numNodes = 0;
            adjacencyList = new ArrayList<List<Integer>>(0);
        } else {
            this.nodes = pNodes;
            this.numNodes = this.nodes.length;
            adjacencyList = new ArrayList(this.nodes.length);
            for (AbstractState node : this.nodes) {
                adjacencyList.add(new ArrayList());
            }
            SuccessorEdgeConstructor edgeConstructor = new SuccessorEdgeConstructor(adjacencyList);
            for (ARGState node : pNodes) {
                edgeConstructor.setPredecessorBeforeARGPass(node);
                edgeConstructor.passARG(node);
            }
        }
        ArrayList<ImmutableList> newList = new ArrayList<ImmutableList>(adjacencyList.size());
        for (int i = 0; i < adjacencyList.size(); ++i) {
            newList.add(ImmutableList.copyOf((Collection)((Collection)adjacencyList.get(i))));
        }
        this.adjacencyList = ImmutableList.copyOf(newList);
    }

    public Set<Integer> getPredecessorsOf(int node) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            if (i == node || !((ImmutableList)this.getAdjacencyList().get(i)).contains((Object)node)) continue;
            ret.add(i);
        }
        return ret;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public List<AbstractState> getNodes() {
        return ImmutableList.copyOf((Object[])this.nodes);
    }

    public ImmutableList<ImmutableList<Integer>> getAdjacencyList() {
        return this.adjacencyList;
    }

    public AbstractState[] getSuccessorNodesOutsideSet(Set<Integer> pNodeSetIndices, boolean pAsARGState) {
        CollectingNodeVisitor visitor = new CollectingNodeVisitor(pAsARGState);
        this.visitOutsideSuccessors(pNodeSetIndices, visitor);
        return visitor.setRes.toArray(new AbstractState[visitor.setRes.size()]);
    }

    public long getNumSuccessorNodesOutsideSet(Set<Integer> pNodeSetIndices) {
        CountingNodeVisitor visitor = new CountingNodeVisitor();
        this.visitOutsideSuccessors(pNodeSetIndices, visitor);
        return visitor.numOutside;
    }

    public long getNumEdgesBetween(Set<Integer> pSrcNodeSetIndices, Set<Integer> pDstNodeSetIndices) {
        CountingNodeVisitor visitor = new CountingNodeVisitor();
        this.visitOutsideAdjacentNodes(pSrcNodeSetIndices, pDstNodeSetIndices, visitor);
        return visitor.numOutside;
    }

    public long getNumEdgesBetween(Integer pSrcNodeIndex, Set<Integer> pDstNodeSetIndices) {
        return this.getNumEdgesBetween(Sets.newHashSet((Object[])new Integer[]{pSrcNodeIndex}), pDstNodeSetIndices);
    }

    public AbstractState[] getSetNodes(Set<Integer> pNodeSetIndices, boolean pAsARGState) {
        ArrayList<AbstractState> listRes = new ArrayList<AbstractState>();
        try {
            for (Integer node : pNodeSetIndices) {
                if (pAsARGState) {
                    listRes.add(this.nodes[node]);
                    continue;
                }
                listRes.add(((ARGState)this.nodes[node]).getWrappedState());
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices must be within [0;" + this.numNodes + "-1].");
        }
        return listRes.toArray(new AbstractState[listRes.size()]);
    }

    private void visitOutsideSuccessorsOf(int pPredecessor, NodeVisitor pVisitor, Predicate<Integer> pMustVisit) {
        for (Integer successor : (ImmutableList)this.adjacencyList.get(pPredecessor)) {
            if (!pMustVisit.apply((Object)successor)) continue;
            pVisitor.visit(successor);
        }
    }

    private void visitOutsideSuccessors(final Set<Integer> pNodeSet, NodeVisitor pVisitor) {
        try {
            Predicate<Integer> isOutsideSet = new Predicate<Integer>(){

                public boolean apply(@Nullable Integer pNode) {
                    return !pNodeSet.contains(pNode);
                }
            };
            for (int predecessor : pNodeSet) {
                this.visitOutsideSuccessorsOf(predecessor, pVisitor, isOutsideSet);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices be within [0;" + this.numNodes + "-1].");
        }
    }

    private void visitOutsideAdjacentNodes(Set<Integer> pSrcNodeSetIndices, Set<Integer> pDstNodeSetIndices, NodeVisitor pVisitor) {
        try {
            this.visitSuccessorsInOtherSet(pSrcNodeSetIndices, pDstNodeSetIndices, pVisitor);
            this.visitSuccessorsInOtherSet(pDstNodeSetIndices, pSrcNodeSetIndices, pVisitor);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices be within [0;" + this.numNodes + "-1].");
        }
    }

    private void visitSuccessorsInOtherSet(Set<Integer> pNodeSet, final Set<Integer> pOtherNodeSet, NodeVisitor pVisitor) {
        Predicate<Integer> isInOtherSet = new Predicate<Integer>(){

            public boolean apply(@Nullable Integer pNode) {
                return pOtherNodeSet.contains(pNode);
            }
        };
        for (int predecessor : pNodeSet) {
            this.visitOutsideSuccessorsOf(predecessor, pVisitor, isInOtherSet);
        }
    }

    private class SuccessorEdgeConstructor
    extends AbstractARGPass {
        private ARGState predecessor;
        private int indexPredecessor;
        private final HashMap<AbstractState, Integer> nodeToIndex;
        private final List<List<Integer>> changeableAdjacencyList;

        public SuccessorEdgeConstructor(List<List<Integer>> pAdjacencyList) {
            super(false);
            this.nodeToIndex = new HashMap();
            for (int i = 0; i < PartialReachedSetDirectedGraph.this.nodes.length; ++i) {
                this.nodeToIndex.put(PartialReachedSetDirectedGraph.this.nodes[i], i);
            }
            this.changeableAdjacencyList = pAdjacencyList;
        }

        public void setPredecessorBeforeARGPass(ARGState pNewPredecessor) {
            this.predecessor = pNewPredecessor;
            this.indexPredecessor = this.nodeToIndex.get(this.predecessor);
        }

        @Override
        public void visitARGNode(ARGState pNode) {
            if (this.stopPathDiscovery(pNode)) {
                while (pNode.isCovered()) {
                    pNode = pNode.getCoveringState();
                }
                int indexSuccessor = this.nodeToIndex.get(pNode);
                this.changeableAdjacencyList.get(this.indexPredecessor).add(indexSuccessor);
            }
        }

        @Override
        public boolean stopPathDiscovery(ARGState pNode) {
            return pNode != this.predecessor && (this.nodeToIndex.containsKey(pNode) || pNode.isCovered());
        }
    }

    private static class CountingNodeVisitor
    implements NodeVisitor {
        private long numOutside = 0L;

        private CountingNodeVisitor() {
        }

        @Override
        public void visit(int pSuccessor) {
            ++this.numOutside;
        }
    }

    private class CollectingNodeVisitor
    implements NodeVisitor {
        private final Set<AbstractState> setRes = new HashSet<AbstractState>();
        private final boolean collectAsARGState;

        public CollectingNodeVisitor(boolean pCollectAsARGState) {
            this.collectAsARGState = pCollectAsARGState;
        }

        @Override
        public void visit(int pSuccessor) {
            if (this.collectAsARGState) {
                this.setRes.add(PartialReachedSetDirectedGraph.this.nodes[pSuccessor]);
            } else {
                this.setRes.add(((ARGState)PartialReachedSetDirectedGraph.this.nodes[pSuccessor]).getWrappedState());
            }
        }
    }

    private static interface NodeVisitor {
        public void visit(int var1);
    }
}

