/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;

public class FiducciaMattheysesAlgorithm {
    private final Set<Integer> v1;
    private final Set<Integer> v2;
    private final PartialReachedSetDirectedGraph graph;
    private final double balanceCriterion;

    public FiducciaMattheysesAlgorithm(double pBalanceCriterion, Set<Integer> pV1, Set<Integer> pV2, PartialReachedSetDirectedGraph pGraph) {
        this.v1 = pV1;
        this.v2 = pV2;
        this.graph = pGraph;
        this.balanceCriterion = pBalanceCriterion;
    }

    private long computeGain(int pNode) {
        Set<Integer> src = this.v1.contains(pNode) ? this.v1 : this.v2;
        Set<Integer> dest = src == this.v1 ? this.v2 : this.v1;
        long dV1 = this.graph.getNumEdgesBetween(pNode, dest);
        long dV2 = this.graph.getNumEdgesBetween(pNode, src);
        return dV1 - dV2;
    }

    private void initDataStructures(Set<Integer> pV, TreeMap<Long, LinkedList<Integer>> pBuckets, HashMap<Integer, Long> pGain, HashMap<Integer, Boolean> lock) {
        for (Integer i : pV) {
            lock.put(i, false);
            long g = this.computeGain(i);
            pGain.put(i, g);
            if (!pBuckets.containsKey(g)) {
                pBuckets.put(g, new LinkedList());
            }
            pBuckets.get(g).addFirst(i);
        }
    }

    private Optional<Pair<Long, TreeMap<Long, LinkedList<Integer>>>> tryFindBestGainWithNonEmptyBucket(final TreeMap<Long, LinkedList<Integer>> bucket) {
        Optional bestGain = Iterables.tryFind(bucket.descendingKeySet(), (Predicate)new Predicate<Long>(){

            public boolean apply(@Nullable Long pLong) {
                return !((LinkedList)bucket.get(pLong)).isEmpty();
            }
        });
        if (!bestGain.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)Pair.of((Object)bestGain.get(), bucket));
    }

    private boolean isBalanced(int pSizeP1, int pSizeP2) {
        int min = Math.min(pSizeP1, pSizeP2);
        if (min <= 0) {
            return false;
        }
        return (double)(Math.max(pSizeP1, pSizeP2) / min) <= this.balanceCriterion;
    }

    private Optional<Pair<Long, TreeMap<Long, LinkedList<Integer>>>> tryPickBestGain(TreeMap<Long, LinkedList<Integer>> bucket1, TreeMap<Long, LinkedList<Integer>> bucket2) {
        Optional<Pair<Long, TreeMap<Long, LinkedList<Integer>>>> bestV1Gain = this.tryFindBestGainWithNonEmptyBucket(bucket1);
        Optional<Pair<Long, TreeMap<Long, LinkedList<Integer>>>> bestV2Gain = this.tryFindBestGainWithNonEmptyBucket(bucket2);
        if (!bestV2Gain.isPresent()) {
            return bestV1Gain;
        }
        if (!bestV1Gain.isPresent()) {
            return bestV2Gain;
        }
        if ((Long)((Pair)bestV1Gain.get()).getFirst() > (Long)((Pair)bestV2Gain.get()).getFirst() && this.isBalanced(this.v1.size() - 1, this.v2.size() + 1)) {
            return bestV1Gain;
        }
        if ((Long)((Pair)bestV1Gain.get()).getFirst() <= (Long)((Pair)bestV2Gain.get()).getFirst() && this.isBalanced(this.v1.size() + 1, this.v2.size() - 1)) {
            return bestV2Gain;
        }
        return Optional.absent();
    }

    private int pollNodeFromBucketByGain(Long gain, TreeMap<Long, LinkedList<Integer>> bucket) {
        return bucket.get(gain).poll();
    }

    private void updateGain(int pNode, TreeMap<Long, LinkedList<Integer>> pBucket, HashMap<Integer, Long> pGain, long pNewGain) {
        boolean success = pBucket.get(pGain.get(pNode)).removeFirstOccurrence(pNode);
        assert (success);
        if (!pBucket.containsKey(pNewGain)) {
            pBucket.put(pNewGain, new LinkedList());
        }
        pBucket.get(pNewGain).add(pNode);
        pGain.put(pNode, pNewGain);
    }

    private void updateNeighbors(int node, TreeMap<Long, LinkedList<Integer>> v1Buckets, TreeMap<Long, LinkedList<Integer>> v2Buckets, HashMap<Integer, Long> gain, HashMap<Integer, Boolean> lock) {
        HashSet<Integer> neighbors = new HashSet<Integer>();
        neighbors.addAll((Collection)this.graph.getAdjacencyList().get(node));
        neighbors.addAll(this.graph.getPredecessorsOf(node));
        Iterator i$ = neighbors.iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            boolean nInV1 = this.v1.contains(n);
            boolean nInV2 = this.v2.contains(n);
            if (!nInV1 && !nInV2 || lock.get(n).booleanValue()) continue;
            long updatedGain = gain.get(n);
            updatedGain = nInV1 && this.v1.contains(node) || nInV2 && this.v2.contains(node) ? ++updatedGain : --updatedGain;
            if (nInV1) {
                this.updateGain(n, v1Buckets, gain, updatedGain);
                continue;
            }
            this.updateGain(n, v2Buckets, gain, updatedGain);
        }
    }

    public long improvePartitioning() {
        Optional<Pair<Long, TreeMap<Long, LinkedList<Integer>>>> gainAndBuckets;
        int i;
        LinkedList<Integer> moved = new LinkedList<Integer>();
        LinkedList<Long> cutSizes = new LinkedList<Long>();
        TreeMap<Long, LinkedList<Integer>> v1Buckets = new TreeMap<Long, LinkedList<Integer>>();
        TreeMap<Long, LinkedList<Integer>> v2Buckets = new TreeMap<Long, LinkedList<Integer>>();
        HashMap<Integer, Long> gain = new HashMap<Integer, Long>();
        HashMap<Integer, Boolean> lock = new HashMap<Integer, Boolean>();
        this.initDataStructures(this.v1, v1Buckets, gain, lock);
        this.initDataStructures(this.v2, v2Buckets, gain, lock);
        cutSizes.add(this.graph.getNumEdgesBetween(this.v1, this.v2));
        int iterationWithSmallestCutSize = 0;
        long smallestCutSize = (Long)cutSizes.get(0);
        for (i = 1; i < this.v1.size() + this.v2.size() && (gainAndBuckets = this.tryPickBestGain(v1Buckets, v2Buckets)).isPresent(); ++i) {
            long g = (Long)((Pair)gainAndBuckets.get()).getFirst();
            int node = this.pollNodeFromBucketByGain(g, (TreeMap)((Pair)gainAndBuckets.get()).getSecond());
            lock.put(node, true);
            this.updateNeighbors(node, v1Buckets, v2Buckets, gain, lock);
            long newCutSize = (Long)cutSizes.getLast() - g;
            assert (newCutSize >= 0L);
            if (newCutSize < smallestCutSize) {
                iterationWithSmallestCutSize = i;
                smallestCutSize = newCutSize;
            }
            moved.add(node);
            cutSizes.addLast(newCutSize);
        }
        i = 1;
        Iterator i$ = moved.iterator();
        while (i$.hasNext()) {
            int node = (Integer)i$.next();
            if (i > iterationWithSmallestCutSize) break;
            if (this.v1.contains(node)) {
                this.v1.remove(node);
                this.v2.add(node);
            } else {
                this.v2.remove(node);
                this.v1.add(node);
            }
            ++i;
        }
        return (Long)cutSizes.getFirst() - smallestCutSize;
    }
}

