/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.ExplorationOrderBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.ExponentialOptimalBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.RandomBalancedGraphPartitioner;

public class GraphPartitionerFactory {
    private GraphPartitionerFactory() {
    }

    public static BalancedGraphPartitioner createPartitioner(LogManager pLogger, PartitioningHeuristics pHeuristic, ShutdownNotifier pShutdownNotifier) {
        switch (pHeuristic) {
            case DFS: {
                return new ExplorationOrderBalancedGraphPartitioner(true, pShutdownNotifier);
            }
            case BFS: {
                return new ExplorationOrderBalancedGraphPartitioner(false, pShutdownNotifier);
            }
            case OPTIMAL: {
                return new ExponentialOptimalBalancedGraphPartitioner(pShutdownNotifier);
            }
            case FM: {
                return new FiducciaMattheysesBalancedGraphPartitioner(pLogger, pShutdownNotifier);
            }
        }
        return new RandomBalancedGraphPartitioner();
    }

    public static enum PartitioningHeuristics {
        RANDOM,
        DFS,
        BFS,
        OPTIMAL,
        FM;

    }
}

