/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningCheckingHelper;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class PartitionChecker {
    private final Multimap<CFANode, AbstractState> partitionParts = HashMultimap.create();
    private final List<AbstractState> certificatePart = new ArrayList<AbstractState>();
    private final Collection<AbstractState> mustBeInCertificate = new HashSet<AbstractState>();
    private final PartitioningCheckingHelper partitionHelper;
    private final PartitioningIOHelper ioHelper;
    private final Precision initPrec;
    private final StopOperator stop;
    private final TransferRelation transfer;
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;

    public PartitionChecker(Precision pInitPrecision, StopOperator pStop, TransferRelation pTransfer, PartitioningIOHelper pIOHelper, PartitioningCheckingHelper pHelperInfo, ShutdownNotifier pShutdownNotifier, LogManager pLogger) {
        this.initPrec = pInitPrecision;
        this.stop = pStop;
        this.transfer = pTransfer;
        this.ioHelper = pIOHelper;
        this.partitionHelper = pHelperInfo;
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
    }

    public void checkPartition(int pIndex) {
        HashMultimap statesPerLocation = HashMultimap.create();
        Pair<AbstractState[], AbstractState[]> partition = this.ioHelper.getPartition(pIndex);
        Preconditions.checkNotNull(partition);
        for (AbstractState internalNode : (AbstractState[])partition.getFirst()) {
            this.addElement(internalNode, true, (Multimap<CFANode, AbstractState>)statesPerLocation);
        }
        for (AbstractState adjacentNode : (AbstractState[])partition.getSecond()) {
            this.addElement(adjacentNode, false, (Multimap<CFANode, AbstractState>)statesPerLocation);
        }
        int nextPos = 0;
        while (nextPos < this.certificatePart.size()) {
            if (this.shutdownNotifier.shouldShutdown()) {
                this.partitionHelper.abortCheckingPreparation();
                return;
            }
            if (this.certificatePart.size() + this.partitionHelper.getCurrentCertificateSize() > this.ioHelper.getSavedReachedSetSize()) {
                this.logger.log(Level.SEVERE, new Object[]{"Checking failed, recomputed certificate bigger than original reached set."});
                this.partitionHelper.abortCheckingPreparation();
                return;
            }
            AbstractState checkedState = this.certificatePart.get(nextPos++);
            try {
                Collection<? extends AbstractState> successors = this.transfer.getAbstractSuccessors(checkedState, this.initPrec);
                for (AbstractState abstractState : successors) {
                    CFANode loc;
                    if (this.stop.stop(abstractState, statesPerLocation.get((Object)(loc = AbstractStates.extractLocation(abstractState))), this.initPrec)) continue;
                    this.certificatePart.add(abstractState);
                }
            }
            catch (InterruptedException | CPATransferException e) {
                this.logger.log(Level.SEVERE, new Object[]{"Checking failed, successor computation failed"});
                this.partitionHelper.abortCheckingPreparation();
                return;
            }
            catch (CPAException e) {
                this.logger.log(Level.SEVERE, new Object[]{"Checking failed, checking successor coverage failed"});
                this.partitionHelper.abortCheckingPreparation();
                return;
            }
        }
    }

    public void addCertificatePartsToCertificate(Collection<AbstractState> pCertificate) {
        pCertificate.addAll(this.certificatePart);
    }

    public void addElementsCheckedInOtherPartitions(Collection<AbstractState> pStatesMustBeInCertificate) {
        pStatesMustBeInCertificate.addAll(this.mustBeInCertificate);
    }

    public void addPartitionElements(Multimap<CFANode, AbstractState> pPartitionElements) {
        pPartitionElements.putAll(this.partitionParts);
    }

    public void clearPartitionElementsSavedForInspection() {
        this.certificatePart.clear();
    }

    public void clearAllSavedPartitioningElements() {
        this.certificatePart.clear();
        this.partitionParts.clear();
        this.mustBeInCertificate.clear();
    }

    private void addElement(AbstractState element, boolean inCertificate, Multimap<CFANode, AbstractState> pStatesPerLocation) {
        CFANode node = AbstractStates.extractLocation(element);
        pStatesPerLocation.put((Object)node, (Object)element);
        if (inCertificate) {
            this.partitionParts.put((Object)node, (Object)element);
            this.certificatePart.add(element);
        } else {
            this.mustBeInCertificate.add(element);
        }
    }

    public static boolean areElementsCoveredByPartitionElement(Collection<AbstractState> pInOtherPartitions, Multimap<CFANode, AbstractState> pInPartition, StopOperator pStop, Precision pPrec) throws CPAException, InterruptedException {
        HashSet partitionNodes = new HashSet(pInPartition.values());
        for (AbstractState outState : pInOtherPartitions) {
            if (partitionNodes.contains(outState) || pStop.stop(outState, pInPartition.get((Object)AbstractStates.extractLocation(outState)), pPrec)) continue;
            return false;
        }
        return true;
    }
}

