/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeTraverser;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public final class AbstractStates {
    public static final Function<AbstractState, CFANode> EXTRACT_LOCATION = new Function<AbstractState, CFANode>(){

        public CFANode apply(AbstractState pArg0) {
            return AbstractStates.extractLocation(pArg0);
        }
    };
    public static final Predicate<AbstractState> IS_TARGET_STATE = new Predicate<AbstractState>(){

        public boolean apply(AbstractState pArg0) {
            return AbstractStates.isTargetState(pArg0);
        }
    };
    private static final Function<AbstractState, Iterable<AbstractState>> AS_ITERABLE = new Function<AbstractState, Iterable<AbstractState>>(){

        public Iterable<AbstractState> apply(AbstractState pState) {
            return AbstractStates.asIterable(pState);
        }
    };

    private AbstractStates() {
    }

    public static <T extends AbstractState> T extractStateByType(AbstractState pState, Class<T> pType) {
        if (pType.isInstance(pState)) {
            return (T)((AbstractState)pType.cast(pState));
        }
        if (pState instanceof AbstractSingleWrapperState) {
            AbstractState wrapped = ((AbstractSingleWrapperState)pState).getWrappedState();
            return AbstractStates.extractStateByType(wrapped, pType);
        }
        if (pState instanceof AbstractWrapperState) {
            for (AbstractState wrapped : ((AbstractWrapperState)pState).getWrappedStates()) {
                T result = AbstractStates.extractStateByType(wrapped, pType);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static <T extends AbstractState> FluentIterable<T> projectToType(Iterable<AbstractState> states, Class<T> pType) {
        return FluentIterable.from(states).transform(AbstractStates.toState(pType)).filter(Predicates.notNull());
    }

    public static CFANode extractLocation(AbstractState pState) {
        AbstractStateWithLocation e = AbstractStates.extractStateByType(pState, AbstractStateWithLocation.class);
        return e == null ? null : e.getLocationNode();
    }

    public static Iterable<AbstractState> filterLocation(Iterable<AbstractState> pStates, CFANode pLoc) {
        if (pStates instanceof LocationMappedReachedSet) {
            return ((LocationMappedReachedSet)pStates).getReached(pLoc);
        }
        Predicate statesWithRightLocation = Predicates.compose((Predicate)Predicates.equalTo((Object)pLoc), EXTRACT_LOCATION);
        return FluentIterable.from(pStates).filter(statesWithRightLocation);
    }

    public static FluentIterable<AbstractState> filterLocations(Iterable<AbstractState> pStates, Set<CFANode> pLocs) {
        if (pStates instanceof LocationMappedReachedSet) {
            final LocationMappedReachedSet states = (LocationMappedReachedSet)pStates;
            return FluentIterable.from(pLocs).transformAndConcat((Function)new Function<CFANode, Iterable<AbstractState>>(){

                public Iterable<AbstractState> apply(CFANode location) {
                    return states.getReached(location);
                }
            });
        }
        Predicate statesWithRightLocation = Predicates.compose((Predicate)Predicates.in(pLocs), EXTRACT_LOCATION);
        return FluentIterable.from(pStates).filter(statesWithRightLocation);
    }

    public static boolean isTargetState(AbstractState as) {
        return as instanceof Targetable && ((Targetable)((Object)as)).isTarget();
    }

    public static <T extends AbstractState> Function<AbstractState, T> toState(final Class<T> pType) {
        return new Function<AbstractState, T>(){

            public T apply(AbstractState as) {
                return AbstractStates.extractStateByType(as, pType);
            }
        };
    }

    public static FluentIterable<AbstractState> asIterable(AbstractState as) {
        return new TreeTraverser<AbstractState>(){

            public Iterable<AbstractState> children(AbstractState state) {
                if (state instanceof AbstractSingleWrapperState) {
                    AbstractState wrapped = ((AbstractSingleWrapperState)state).getWrappedState();
                    return ImmutableList.of((Object)wrapped);
                }
                if (state instanceof AbstractWrapperState) {
                    return ((AbstractWrapperState)state).getWrappedStates();
                }
                return ImmutableList.of();
            }
        }.preOrderTraversal((Object)as);
    }

    public static FluentIterable<AbstractState> asFlatIterable(Iterable<AbstractState> pStates) {
        return FluentIterable.from(pStates).transformAndConcat(AS_ITERABLE);
    }

    public static BooleanFormula extractReportedFormulas(FormulaManagerView manager, AbstractState state) {
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        BooleanFormula result = bfmgr.makeBoolean(true);
        for (FormulaReportingState s : AbstractStates.asIterable(state).filter(FormulaReportingState.class)) {
            result = bfmgr.and(result, s.getFormulaApproximation(manager));
        }
        return result;
    }
}

