/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class CFAUtils {
    public static final Function<CFAEdge, CFANode> TO_PREDECESSOR = new Function<CFAEdge, CFANode>(){

        public CFANode apply(CFAEdge pInput) {
            return pInput.getPredecessor();
        }
    };
    public static final Function<CFAEdge, CFANode> TO_SUCCESSOR = new Function<CFAEdge, CFANode>(){

        public CFANode apply(CFAEdge pInput) {
            return pInput.getSuccessor();
        }
    };
    public static final Function<CFANode, String> GET_FUNCTION = new Function<CFANode, String>(){

        public String apply(CFANode pInput) {
            return pInput.getFunctionName();
        }
    };
    public static final Comparator<CFANode> NODE_NUMBER_COMPARATOR = new Comparator<CFANode>(){

        @Override
        public int compare(CFANode pO1, CFANode pO2) {
            return Integer.compare(pO1.getNodeNumber(), pO2.getNodeNumber());
        }
    };

    public static FluentIterable<CFAEdge> allEnteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getEnteringSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getEnteringSummaryEdge();
                        }
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> enteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> allLeavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getLeavingSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getLeavingSummaryEdge();
                        }
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> leavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFANode> predecessorsOf(CFANode node) {
        return CFAUtils.enteringEdges(node).transform(TO_PREDECESSOR);
    }

    public static FluentIterable<CFANode> allPredecessorsOf(CFANode node) {
        return CFAUtils.allEnteringEdges(node).transform(TO_PREDECESSOR);
    }

    public static FluentIterable<CFANode> successorsOf(CFANode node) {
        return CFAUtils.leavingEdges(node).transform(TO_SUCCESSOR);
    }

    public static FluentIterable<CFANode> allSuccessorsOf(CFANode node) {
        return CFAUtils.allLeavingEdges(node).transform(TO_SUCCESSOR);
    }

    public static Predicate<CFAEdge> edgeHasType(final CFAEdgeType pType) {
        Preconditions.checkNotNull((Object)((Object)pType));
        return new Predicate<CFAEdge>(){

            public boolean apply(CFAEdge pInput) {
                return pInput.getEdgeType() == pType;
            }
        };
    }

    public static AssumeEdge getComplimentaryAssumeEdge(AssumeEdge edge) {
        Preconditions.checkArgument((edge.getPredecessor().getNumLeavingEdges() == 2 ? 1 : 0) != 0);
        return (AssumeEdge)Iterables.getOnlyElement((Iterable)CFAUtils.leavingEdges(edge.getPredecessor()).filter(Predicates.not((Predicate)Predicates.equalTo((Object)edge))));
    }

    public static boolean existsPath(CFANode pSource, CFANode pTarget, Function<CFANode, Iterable<CFAEdge>> pGetLeavingEdges, ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(pSource);
        while (!waitlist.isEmpty()) {
            pShutdownNotifier.shutdownIfNecessary();
            CFANode current = (CFANode)waitlist.poll();
            if (current.equals(pTarget)) {
                return true;
            }
            if (!visited.add(current)) continue;
            for (CFAEdge leavingEdge : (Iterable)pGetLeavingEdges.apply((Object)current)) {
                CFANode succ = leavingEdge.getSuccessor();
                waitlist.offer(succ);
            }
        }
        return false;
    }

    static boolean hasBackWardsEdges(CFANode rootNode) {
        FindBackwardsEdgesVisitor visitor = new FindBackwardsEdgesVisitor();
        CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(rootNode, visitor);
        return visitor.hasBackwardsEdges();
    }

    public static SortedSet<String> filterVariablesOfFunction(SortedSet<String> variables, String function) {
        String prefix = (String)Preconditions.checkNotNull((Object)function) + "::";
        return Collections3.subSetWithPrefix(variables, (String)prefix);
    }

    private static class FindBackwardsEdgesVisitor
    extends CFATraversal.DefaultCFAVisitor {
        private boolean hasBackwardsEdges = false;

        private FindBackwardsEdgesVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            if (pNode.getNumLeavingEdges() == 0) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            if (pNode.getNumLeavingEdges() == 1 && pNode.getLeavingEdge(0).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId()) {
                this.hasBackwardsEdges = true;
                return CFATraversal.TraversalProcess.ABORT;
            }
            if (pNode.getNumLeavingEdges() == 2 && (pNode.getLeavingEdge(0).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId() || pNode.getLeavingEdge(1).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId())) {
                this.hasBackwardsEdges = true;
                return CFATraversal.TraversalProcess.ABORT;
            }
            if (pNode.getNumLeavingEdges() > 2) {
                throw new AssertionError((Object)"forgotten case in traversing cfa with more than 2 leaving edges");
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        public boolean hasBackwardsEdges() {
            return this.hasBackwardsEdges;
        }
    }
}

