/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeTraverser;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;

public class CPAs {
    private CPAs() {
    }

    public static <T extends ConfigurableProgramAnalysis> T retrieveCPA(ConfigurableProgramAnalysis cpa, Class<T> cls) {
        if (cls.isInstance(cpa)) {
            return (T)((ConfigurableProgramAnalysis)cls.cast(cpa));
        }
        if (cpa instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(cls);
        }
        return null;
    }

    public static FluentIterable<ConfigurableProgramAnalysis> asIterable(ConfigurableProgramAnalysis pCpa) {
        return new TreeTraverser<ConfigurableProgramAnalysis>(){

            public Iterable<ConfigurableProgramAnalysis> children(ConfigurableProgramAnalysis cpa) {
                return cpa instanceof WrapperCPA ? ((WrapperCPA)((Object)cpa)).getWrappedCPAs() : ImmutableList.of();
            }
        }.preOrderTraversal((Object)pCpa);
    }

    public static void closeCpaIfPossible(ConfigurableProgramAnalysis cpa, LogManager logger) {
        for (ConfigurableProgramAnalysis currentCpa : CPAs.asIterable(cpa)) {
            CPAs.closeIfPossible(currentCpa, logger);
        }
    }

    public static void closeIfPossible(Object obj, LogManager logger) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                logger.logUserException(Level.WARNING, (Throwable)e, "Failed to close " + obj.getClass().getSimpleName());
            }
        }
    }
}

