/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.HashSet;
import org.sosy_lab.common.Pair;

public class GraphUtils {
    private GraphUtils() {
    }

    public static <N> SetMultimap<N, N> projectARG(N root, Function<? super N, ? extends Iterable<N>> successorFunction, Predicate<? super N> isRelevant) {
        isRelevant = Predicates.or((Predicate)Predicates.equalTo(root), isRelevant);
        HashMultimap successors = HashMultimap.create();
        ArrayDeque<Pair> todo = new ArrayDeque<Pair>();
        HashSet<Object> visited = new HashSet<Object>();
        todo.push(Pair.of(root, root));
        while (!todo.isEmpty()) {
            Pair currentPair = (Pair)todo.pop();
            Object currentPredecessor = currentPair.getFirst();
            Object currentState = currentPair.getSecond();
            if (!visited.add(currentState)) continue;
            for (Object child : (Iterable)successorFunction.apply(currentState)) {
                if (isRelevant.apply(child)) {
                    successors.put(currentPredecessor, child);
                    todo.push(Pair.of(child, child));
                    continue;
                }
                todo.push(Pair.of((Object)currentPredecessor, child));
            }
        }
        return successors;
    }
}

