/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;

public class LiveVariables {
    private final Multimap<CFANode, ASimpleDeclaration> liveVariables;
    private final Set<ASimpleDeclaration> globalVariables;
    private final VariableClassification variableClassification;
    private final EvaluationStrategy evaluationStrategy;
    private final Language language;
    private final Multimap<CFANode, String> liveVariablesStrings;
    private final Set<String> globalVariablesStrings;
    private static final Function<Pair<ADeclaration, String>, ASimpleDeclaration> DECLARATION_FILTER = new Function<Pair<ADeclaration, String>, ASimpleDeclaration>(){

        public ASimpleDeclaration apply(Pair<ADeclaration, String> pInput) {
            return (ASimpleDeclaration)pInput.getFirst();
        }
    };

    private LiveVariables(Multimap<CFANode, ASimpleDeclaration> pLiveVariables, VariableClassification pVariableClassification, Set<ASimpleDeclaration> pGlobalVariables, EvaluationStrategy pEvaluationStrategy, Language pLanguage) {
        this.liveVariables = pLiveVariables;
        this.globalVariables = pGlobalVariables;
        this.variableClassification = pVariableClassification;
        this.evaluationStrategy = pEvaluationStrategy;
        this.language = pLanguage;
        this.globalVariablesStrings = FluentIterable.from(this.globalVariables).transform((Function)new Function<ASimpleDeclaration, String>(){

            public String apply(ASimpleDeclaration pInput) {
                return pInput.getQualifiedName();
            }
        }).toSet();
        this.liveVariablesStrings = HashMultimap.create();
        for (Map.Entry e : this.liveVariables.entries()) {
            this.liveVariablesStrings.put(e.getKey(), (Object)((ASimpleDeclaration)e.getValue()).getQualifiedName());
        }
    }

    public boolean isVariableLive(ASimpleDeclaration variable, CFANode location) {
        String varName = variable.getQualifiedName();
        if (this.globalVariables.contains(variable) || this.language == Language.C && this.variableClassification.getAddressedVariables().contains(varName) || this.evaluationStrategy == EvaluationStrategy.FUNCTION_WISE && !varName.startsWith(location.getFunctionName())) {
            return true;
        }
        return this.liveVariables.containsEntry((Object)location, (Object)variable);
    }

    public boolean isVariableLive(String varName, CFANode location) {
        if (this.globalVariablesStrings.contains(varName) || this.language == Language.C && this.variableClassification.getAddressedVariables().contains(varName) || this.evaluationStrategy == EvaluationStrategy.FUNCTION_WISE && !varName.startsWith(location.getFunctionName())) {
            return true;
        }
        return this.liveVariablesStrings.containsEntry((Object)location, (Object)varName);
    }

    public Set<ASimpleDeclaration> getLiveVariablesForNode(CFANode node) {
        return ImmutableSet.builder().addAll((Iterable)this.liveVariables.get((Object)node)).addAll(this.globalVariables).build();
    }

    public Set<String> getLiveVariableNamesForNode(CFANode pNode) {
        return Sets.newHashSet((Iterable)Collections2.transform(this.getLiveVariablesForNode(pNode), (Function)new Function<ASimpleDeclaration, String>(){

            public String apply(ASimpleDeclaration pDecl) {
                return pDecl.getQualifiedName();
            }
        }));
    }

    public static Optional<LiveVariables> create(Optional<VariableClassification> variableClassification, List<Pair<ADeclaration, String>> globalsList, MutableCFA pCFA, LogManager logger, ShutdownNotifier shutdownNotifier, Configuration config) throws InvalidConfigurationException {
        Preconditions.checkNotNull(variableClassification);
        Preconditions.checkNotNull(globalsList);
        Preconditions.checkNotNull((Object)pCFA);
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)shutdownNotifier);
        if (pCFA.getLanguage() == Language.C && !variableClassification.isPresent()) {
            return Optional.absent();
        }
        ImmutableCFA cfa = pCFA.makeImmutableCFA(variableClassification);
        LiveVariablesConfiguration liveVarConfig = new LiveVariablesConfiguration(config);
        return LiveVariables.create0((VariableClassification)variableClassification.orNull(), globalsList, logger, shutdownNotifier, cfa, liveVarConfig.evaluationStrategy);
    }

    private static Optional<LiveVariables> create0(VariableClassification variableClassification, List<Pair<ADeclaration, String>> globalsList, LogManager logger, ShutdownNotifier shutdownNotifier, CFA cfa, EvaluationStrategy eval) throws AssertionError {
        ImmutableSet globalVariables;
        switch (eval) {
            case FUNCTION_WISE: {
                globalVariables = FluentIterable.from(globalsList).transform(DECLARATION_FILTER).filter(Predicates.notNull()).filter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(CTypeDeclaration.class), (Predicate)Predicates.instanceOf(CFunctionDeclaration.class)))).toSet();
                break;
            }
            case GLOBAL: {
                globalVariables = Collections.emptySet();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled case statement: " + (Object)((Object)eval)));
            }
        }
        Optional<AnalysisParts> parts = LiveVariables.getNecessaryAnalysisComponents(cfa, logger, shutdownNotifier, eval);
        Multimap<CFANode, ASimpleDeclaration> liveVariables = null;
        if (parts.isPresent()) {
            liveVariables = LiveVariables.addLiveVariablesFromCFA(cfa, logger, (AnalysisParts)parts.get(), eval);
        }
        if (liveVariables == null && eval != EvaluationStrategy.FUNCTION_WISE) {
            logger.log(Level.INFO, new Object[]{"Global live variables collection failed, fallback to function-wise analysis."});
            return LiveVariables.create0(variableClassification, globalsList, logger, shutdownNotifier, cfa, EvaluationStrategy.FUNCTION_WISE);
        }
        if (liveVariables == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new LiveVariables(liveVariables, variableClassification, (Set<ASimpleDeclaration>)globalVariables, eval, cfa.getLanguage()));
    }

    private static Multimap<CFANode, ASimpleDeclaration> addLiveVariablesFromCFA(CFA pCfa, LogManager logger, AnalysisParts analysisParts, EvaluationStrategy evaluationStrategy) {
        Collection<FunctionEntryNode> functionHeads;
        Optional<LoopStructure> loopStructure = pCfa.getLoopStructure();
        switch (evaluationStrategy) {
            case FUNCTION_WISE: {
                functionHeads = pCfa.getAllFunctionHeads();
                break;
            }
            case GLOBAL: {
                functionHeads = Collections.singleton(pCfa.getMainFunction());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandeld case statement: " + (Object)((Object)evaluationStrategy)));
            }
        }
        for (FunctionEntryNode node : functionHeads) {
            FunctionExitNode exitNode = node.getExitNode();
            if (!pCfa.getAllNodes().contains(exitNode)) continue;
            analysisParts.reachedSet.add(analysisParts.cpa.getInitialState(exitNode, StateSpacePartition.getDefaultPartition()), analysisParts.cpa.getInitialPrecision(exitNode, StateSpacePartition.getDefaultPartition()));
        }
        if (loopStructure.isPresent()) {
            LoopStructure structure = (LoopStructure)loopStructure.get();
            ImmutableCollection<LoopStructure.Loop> loops = structure.getAllLoops();
            for (LoopStructure.Loop l : loops) {
                if (!FluentIterable.from(l.getOutgoingEdges()).filter(Predicates.not((Predicate)Predicates.instanceOf(FunctionCallEdge.class))).isEmpty()) continue;
                CFANode functionHead = (CFANode)l.getLoopHeads().iterator().next();
                analysisParts.reachedSet.add(analysisParts.cpa.getInitialState(functionHead, StateSpacePartition.getDefaultPartition()), analysisParts.cpa.getInitialPrecision(functionHead, StateSpacePartition.getDefaultPartition()));
            }
        }
        logger.log(Level.INFO, new Object[]{"Starting live variables collection ..."});
        try {
            do {
                analysisParts.algorithm.run(analysisParts.reachedSet);
            } while (analysisParts.reachedSet.hasWaitingState());
        }
        catch (InterruptedException | CPAException e) {
            logger.logUserException(Level.WARNING, (Throwable)e, "Could not compute live variables.");
            return null;
        }
        logger.log(Level.INFO, new Object[]{"Stopping live variables collection ..."});
        LiveVariablesCPA liveVarCPA = ((WrapperCPA)((Object)analysisParts.cpa)).retrieveWrappedCpa(LiveVariablesCPA.class);
        return liveVarCPA.getLiveVariables();
    }

    private static Optional<AnalysisParts> getNecessaryAnalysisComponents(CFA cfa, LogManager logger, ShutdownNotifier shutdownNotifier, EvaluationStrategy evaluationStrategy) {
        try {
            Configuration config;
            switch (evaluationStrategy) {
                case FUNCTION_WISE: {
                    config = LiveVariables.getLocalConfiguration();
                    break;
                }
                case GLOBAL: {
                    config = LiveVariables.getGlobalConfiguration();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled case statement: " + (Object)((Object)evaluationStrategy)));
                }
            }
            ReachedSetFactory reachedFactory = new ReachedSetFactory(config, logger);
            ConfigurableProgramAnalysis cpa = new CPABuilder(config, logger, shutdownNotifier, reachedFactory).buildCPAWithSpecAutomatas(cfa);
            CPAAlgorithm algorithm = CPAAlgorithm.create(cpa, logger, config, shutdownNotifier);
            ReachedSet reached = reachedFactory.create();
            return Optional.of((Object)new AnalysisParts(cpa, algorithm, reached));
        }
        catch (InvalidConfigurationException | CPAException e) {
            logger.logUserException(Level.WARNING, e, "An error occured during the creation of the necessary CPA parts for the live variables analysis.");
            return Optional.absent();
        }
    }

    private static Configuration getGlobalConfiguration() throws InvalidConfigurationException {
        ConfigurationBuilder configBuilder = Configuration.builder();
        configBuilder.setOption("analysis.traversal.order", "BFS");
        configBuilder.setOption("analysis.traversal.usePostorder", "true");
        configBuilder.setOption("analysis.traversal.useCallstack", "true");
        configBuilder.setOption("cpa", "cpa.composite.CompositeCPA");
        configBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPABackwardsNoTargets,cpa.callstack.CallstackCPABackwards,cpa.livevar.LiveVariablesCPA");
        configBuilder.setOption("cpa.location.followFunctionCalls", "true");
        configBuilder.setOption("cpa.liveVar.assumeGlobalVariablesAreAlwaysLive", "false");
        return configBuilder.build();
    }

    private static Configuration getLocalConfiguration() throws InvalidConfigurationException {
        ConfigurationBuilder configBuilder = Configuration.builder();
        configBuilder.setOption("analysis.traversal.order", "BFS");
        configBuilder.setOption("analysis.traversal.usePostorder", "true");
        configBuilder.setOption("cpa", "cpa.composite.CompositeCPA");
        configBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPABackwardsNoTargets,cpa.livevar.LiveVariablesCPA");
        configBuilder.setOption("cpa.location.followFunctionCalls", "false");
        configBuilder.setOption("cpa.liveVar.assumeGlobalVariablesAreAlwaysLive", "true");
        return configBuilder.build();
    }

    private static class AnalysisParts {
        private final ConfigurableProgramAnalysis cpa;
        private final Algorithm algorithm;
        private final ReachedSet reachedSet;

        private AnalysisParts(ConfigurableProgramAnalysis pCPA, Algorithm pAlgorithm, ReachedSet pReachedSet) {
            this.cpa = pCPA;
            this.algorithm = pAlgorithm;
            this.reachedSet = pReachedSet;
        }
    }

    @Options(prefix="liveVar")
    private static class LiveVariablesConfiguration {
        @Option(toUppercase=true, description="By changing this option one can adjust the way how live variables are created. Function-wise means that each function is handled separately, global means that the whole cfa is used for the computation.", secure=true)
        private EvaluationStrategy evaluationStrategy = EvaluationStrategy.FUNCTION_WISE;

        public LiveVariablesConfiguration(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }
    }

    public static enum EvaluationStrategy {
        FUNCTION_WISE,
        GLOBAL;

    }
}

