/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public class NativeLibraries {
    private static Path nativePath = null;

    private NativeLibraries() {
    }

    public static Path getNativeLibraryPath() {
        if (nativePath == null) {
            URI pathToJar;
            String arch = Architecture.guessVmArchitecture().name().toLowerCase();
            String os = OS.guessOperatingSystem().name().toLowerCase();
            try {
                pathToJar = NativeLibraries.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
            nativePath = Paths.get((URI)pathToJar).getParent().resolve(Paths.get((String)"lib", (String[])new String[]{"native", arch + "-" + os}));
        }
        return nativePath;
    }

    public static void loadLibrary(String name) {
        try {
            System.loadLibrary(name);
        }
        catch (UnsatisfiedLinkError firstEx) {
            try {
                Path file = NativeLibraries.getNativeLibraryPath().resolve(System.mapLibraryName(name)).toAbsolutePath();
                System.load(file.toString());
            }
            catch (Throwable t) {
                t.addSuppressed(firstEx);
                throw t;
            }
        }
    }

    public static enum Architecture {
        X86,
        X86_64;

        private static Architecture CURRENT_ARCH;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Architecture guessVmArchitecture() throws UnsatisfiedLinkError {
            if (CURRENT_ARCH != null) {
                return CURRENT_ARCH;
            }
            String prop = System.getProperty("os.arch.data.model");
            if (Strings.isNullOrEmpty((String)prop)) {
                prop = System.getProperty("sun.arch.data.model");
            }
            if (!Strings.isNullOrEmpty((String)prop)) {
                if (prop.equals("32")) {
                    CURRENT_ARCH = X86;
                    return CURRENT_ARCH;
                } else {
                    if (!prop.equals("64")) throw new UnsatisfiedLinkError("Unknown value for os.arch.data.model: '" + prop + "', please report this together with information about your system (OS, architecture, JVM).");
                    CURRENT_ARCH = X86_64;
                }
                return CURRENT_ARCH;
            } else {
                prop = StandardSystemProperty.JAVA_VM_NAME.value();
                if (Strings.isNullOrEmpty((String)prop)) throw new UnsatisfiedLinkError("Could not detect system architecture");
                if ((prop = prop.toLowerCase()).contains("32-bit") || prop.contains("32bit") || prop.contains("i386")) {
                    CURRENT_ARCH = X86;
                    return CURRENT_ARCH;
                } else {
                    if (!prop.contains("64-bit") && !prop.contains("64bit") && !prop.contains("x64") && !prop.contains("x86_64") && !prop.contains("amd64")) throw new UnsatisfiedLinkError("Unknown value for java.vm.name: '" + prop + "', please report this together with information about your system (OS, architecture, JVM).");
                    CURRENT_ARCH = X86_64;
                }
            }
            return CURRENT_ARCH;
        }

        static {
            CURRENT_ARCH = null;
        }
    }

    public static enum OS {
        LINUX,
        MACOSX,
        WINDOWS;

        private static OS CURRENT_OS;

        public static OS guessOperatingSystem() throws UnsatisfiedLinkError {
            if (CURRENT_OS != null) {
                return CURRENT_OS;
            }
            String prop = StandardSystemProperty.OS_NAME.value();
            if (Strings.isNullOrEmpty((String)prop)) {
                throw new UnsatisfiedLinkError("No value for os.name, please report this together with information about your system (OS, architecture, JVM).");
            }
            if ((prop = prop.toLowerCase().replace(" ", "")).startsWith("linux")) {
                CURRENT_OS = LINUX;
            } else if (prop.startsWith("windows")) {
                CURRENT_OS = WINDOWS;
            } else if (prop.startsWith("macosx")) {
                CURRENT_OS = MACOSX;
            } else {
                throw new UnsatisfiedLinkError("Unknown value for os.name: '" + StandardSystemProperty.OS_NAME.value() + "', please report this together with information about your system (OS, architecture, JVM).");
            }
            return CURRENT_OS;
        }

        static {
            CURRENT_OS = null;
        }
    }
}

