/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.io.Path;

public class PropertyFileParser {
    private final Path propertyFile;
    private String entryFunction;
    private final EnumSet<PropertyType> properties = EnumSet.noneOf(PropertyType.class);
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("CHECK\\( init\\(([_a-zA-Z][_a-zA-Z0-9]*)\\(\\)\\), LTL\\((.+)\\) \\)");

    public PropertyFileParser(Path pPropertyFile) {
        this.propertyFile = pPropertyFile;
    }

    public void parse() throws InvalidPropertyFileException {
        String rawProperty = null;
        try (BufferedReader br = this.propertyFile.asCharSource(Charset.defaultCharset()).openBufferedStream();){
            while ((rawProperty = br.readLine()) != null) {
                if (rawProperty.isEmpty()) continue;
                this.properties.add(this.parsePropertyLine(rawProperty));
            }
        }
        catch (IOException e) {
            throw new InvalidPropertyFileException("Could not read file: " + e.getMessage(), e);
        }
        if (this.properties.isEmpty()) {
            throw new InvalidPropertyFileException("No property in file.");
        }
    }

    private PropertyType parsePropertyLine(String rawProperty) throws InvalidPropertyFileException {
        Matcher matcher = PROPERTY_PATTERN.matcher(rawProperty);
        if (rawProperty == null || !matcher.matches() || matcher.groupCount() != 2) {
            throw new InvalidPropertyFileException(String.format("The given property '%s' is not well-formed!", rawProperty));
        }
        if (this.entryFunction == null) {
            this.entryFunction = matcher.group(1);
        } else if (!this.entryFunction.equals(matcher.group(1))) {
            throw new InvalidPropertyFileException(String.format("Specifying two different entry functions %s and %s is not supported.", this.entryFunction, matcher.group(1)));
        }
        PropertyType property = (PropertyType)((Object)PropertyType.AVAILABLE_PROPERTIES.get((Object)matcher.group(2)));
        if (property == null) {
            throw new InvalidPropertyFileException(String.format("The property '%s' is not supported.", matcher.group(2)));
        }
        return property;
    }

    public String getEntryFunction() {
        return this.entryFunction;
    }

    public EnumSet<PropertyType> getProperties() {
        return this.properties;
    }

    public static enum PropertyType {
        REACHABILITY_LABEL,
        REACHABILITY,
        VALID_FREE,
        VALID_DEREF,
        VALID_MEMTRACK;

        private static ImmutableMap<String, PropertyType> AVAILABLE_PROPERTIES;

        static {
            AVAILABLE_PROPERTIES = ImmutableMap.of((Object)"G ! label(ERROR)", (Object)((Object)REACHABILITY_LABEL), (Object)"G ! call(__VERIFIER_error())", (Object)((Object)REACHABILITY), (Object)"G valid-free", (Object)((Object)VALID_FREE), (Object)"G valid-deref", (Object)((Object)VALID_DEREF), (Object)"G valid-memtrack", (Object)((Object)VALID_MEMTRACK));
        }
    }

    public static class InvalidPropertyFileException
    extends Exception {
        private static final long serialVersionUID = -5880923544560903123L;

        public InvalidPropertyFileException(String msg) {
            super(msg);
        }

        public InvalidPropertyFileException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

