/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpressionCollectingVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.FileLocationCollectingVisitor;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SourceLocationMapper {
    private static Map<String, Set<Integer>> variableRelatedTokens = Maps.newHashMap();
    private static Map<Integer, Token> tokenNumberToTokenMap = Maps.newHashMap();
    private static Map<Integer, Integer> tokenNumberToLineNumberMap = Maps.newHashMap();

    public static Set<String> matchTokenNumbersToTokenStrings(Set<Integer> tokenNumbers) {
        return Collections.emptySet();
    }

    public static void storeTokenInformation(Token token, int lineNumber, int tokenNumber) {
        tokenNumberToTokenMap.put(tokenNumber, token);
        tokenNumberToLineNumberMap.put(tokenNumber, lineNumber);
    }

    private static void collectLine(SortedSet<Integer> target, FileLocation loc, boolean overApproximateTokens) {
        if (loc != null && !loc.equals(FileLocation.DUMMY)) {
            if (overApproximateTokens) {
                int lowerBound = loc.getStartingLineNumber();
                int upperBound = loc.getEndingLineNumber();
                if (target.size() > 0) {
                    lowerBound = Math.min(lowerBound, target.first());
                    upperBound = Math.max(upperBound, target.last());
                }
                for (int line = lowerBound; line <= upperBound; ++line) {
                    target.add(line);
                }
            } else {
                target.add(loc.getStartingLineNumber());
            }
        }
    }

    public static Set<Integer> collectTokensFrom(CAstNode astNode, boolean overApproximateTokens) {
        TreeSet result = Sets.newTreeSet();
        Set<FileLocation> locs = SourceLocationMapper.collectFileLocationsFrom(astNode);
        for (FileLocation l : locs) {
            SourceLocationMapper.collectLine(result, l, overApproximateTokens);
        }
        return result;
    }

    public static synchronized Set<RowAndColumn> collectRowsAndColsFrom(CAstNode astNode, boolean overApproximateTokens) {
        TreeSet result = Sets.newTreeSet();
        Set<FileLocation> locs = SourceLocationMapper.collectFileLocationsFrom(astNode);
        for (FileLocation l : locs) {
            RowAndColumn rc = new RowAndColumn(l.getStartingLineNumber(), l.getNodeOffset());
            result.add(rc);
        }
        return result;
    }

    public static synchronized Set<FileLocation> collectFileLocationsFrom(CAstNode astNode) {
        FileLocationCollectingVisitor visitor = new FileLocationCollectingVisitor();
        return astNode.accept(visitor);
    }

    public static synchronized Set<CAstNode> getAstNodesFromCfaEdge(CFAEdge pEdge) {
        HashSet result = Sets.newHashSet();
        ArrayDeque edges = Queues.newArrayDeque();
        edges.add(pEdge);
        while (!edges.isEmpty()) {
            CFAEdge edge = (CFAEdge)edges.pop();
            switch (edge.getEdgeType()) {
                case MultiEdge: {
                    edges.addAll(((MultiEdge)edge).getEdges());
                    break;
                }
                case AssumeEdge: {
                    result.add(((CAssumeEdge)edge).getExpression());
                    break;
                }
                case CallToReturnEdge: {
                    CFunctionSummaryEdge fnSumEdge = (CFunctionSummaryEdge)edge;
                    result.add(fnSumEdge.getExpression());
                    break;
                }
                case DeclarationEdge: {
                    result.add(((CDeclarationEdge)edge).getDeclaration());
                    break;
                }
                case FunctionCallEdge: {
                    if (edge.getPredecessor().getLeavingSummaryEdge() != null) {
                        edges.add(edge.getPredecessor().getLeavingSummaryEdge());
                    }
                    result.addAll(((CFunctionCallEdge)edge).getArguments());
                    break;
                }
                case FunctionReturnEdge: {
                    break;
                }
                case ReturnStatementEdge: {
                    CReturnStatementEdge retStmt = (CReturnStatementEdge)edge;
                    if (retStmt.getRawAST().isPresent()) {
                        result.add(retStmt.getRawAST().get());
                    }
                    if (!retStmt.getExpression().isPresent()) break;
                    result.add(retStmt.getExpression().get());
                    break;
                }
                case StatementEdge: {
                    result.add(((CStatementEdge)edge).getStatement());
                }
            }
        }
        return result;
    }

    public static synchronized Set<FileLocation> getFileLocationsFromCfaEdge(CFAEdge pEdge) {
        HashSet result = Sets.newHashSet();
        Set<CAstNode> astNodes = SourceLocationMapper.getAstNodesFromCfaEdge(pEdge);
        for (CAstNode n : astNodes) {
            result.addAll(SourceLocationMapper.collectFileLocationsFrom(n));
        }
        result.add(pEdge.getFileLocation());
        return FluentIterable.from((Iterable)result).filter(Predicates.not((Predicate)Predicates.equalTo((Object)FileLocation.DUMMY))).toSet();
    }

    public static synchronized Set<RowAndColumn> getRowsAndColsFromCFAEdge(CFAEdge pEdge, boolean overApproximateTokens) {
        TreeSet result = Sets.newTreeSet();
        Set<CAstNode> astNodes = SourceLocationMapper.getAstNodesFromCfaEdge(pEdge);
        for (CAstNode n : astNodes) {
            result.addAll(SourceLocationMapper.collectRowsAndColsFrom(n, overApproximateTokens));
        }
        RowAndColumn rc = new RowAndColumn(pEdge.getFileLocation().getStartingLineNumber(), pEdge.getFileLocation().getNodeOffset());
        result.add(rc);
        return result;
    }

    public static synchronized Set<Integer> getAbsoluteTokensFromCFAEdge(CFAEdge pEdge, boolean overApproximateTokens) {
        TreeSet result = Sets.newTreeSet();
        ArrayDeque edges = Queues.newArrayDeque();
        ArrayDeque astNodes = Queues.newArrayDeque();
        if (overApproximateTokens) {
            Set<String> variables = SourceLocationMapper.getEdgeVariableNames(pEdge);
            for (String variable : variables) {
                if (!variable.contains("__CPA")) continue;
                Set<Integer> tokens = variableRelatedTokens.get(variable);
                if (tokens != null) {
                    result.addAll(tokens);
                    continue;
                }
                result.addAll(Collections.emptySet());
            }
        }
        edges.add(pEdge);
        while (!edges.isEmpty()) {
            CFAEdge edge = (CFAEdge)edges.pop();
            CFANode startNode = edge.getPredecessor();
            if (overApproximateTokens) {
                result.add(edge.getLineNumber());
            }
            switch (edge.getEdgeType()) {
                case MultiEdge: {
                    edges.addAll(((MultiEdge)edge).getEdges());
                    break;
                }
                case AssumeEdge: {
                    if (overApproximateTokens) {
                        result.add(edge.getFileLocation().getEndingLineNumber());
                        for (CFAEdge e : CFAUtils.enteringEdges(startNode)) {
                            if (!(e instanceof BlankEdge)) continue;
                            result.add(e.getLineNumber());
                        }
                    }
                    CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                    astNodes.add(assumeEdge.getExpression());
                    break;
                }
                case CallToReturnEdge: {
                    CFunctionSummaryEdge fnSumEdge = (CFunctionSummaryEdge)edge;
                    result.add(fnSumEdge.getLineNumber());
                    astNodes.add(fnSumEdge.getExpression());
                    break;
                }
                case DeclarationEdge: {
                    CVariableDeclaration varDecl;
                    CDeclaration decl = ((CDeclarationEdge)edge).getDeclaration();
                    SourceLocationMapper.collectLine(result, decl.getFileLocation(), overApproximateTokens);
                    if (!(decl instanceof CVariableDeclaration) || (varDecl = (CVariableDeclaration)decl).getInitializer() == null) break;
                    result.addAll(SourceLocationMapper.collectTokensFrom(varDecl.getInitializer(), overApproximateTokens));
                    break;
                }
                case FunctionCallEdge: {
                    if (edge.getPredecessor().getLeavingSummaryEdge() != null) {
                        edges.add(edge.getPredecessor().getLeavingSummaryEdge());
                    }
                    result.add(((CFunctionCallEdge)edge).getLineNumber());
                    astNodes.addAll(((CFunctionCallEdge)edge).getArguments());
                    break;
                }
                case FunctionReturnEdge: {
                    result.add(((CFunctionReturnEdge)edge).getLineNumber());
                    break;
                }
                case ReturnStatementEdge: {
                    result.add(((CReturnStatementEdge)edge).getLineNumber());
                    Optional<CExpression> expr = ((CReturnStatementEdge)edge).getExpression();
                    if (!expr.isPresent()) break;
                    astNodes.add(expr.get());
                    break;
                }
                case StatementEdge: {
                    result.addAll(SourceLocationMapper.collectTokensFrom(((CStatementEdge)edge).getStatement(), overApproximateTokens));
                }
            }
            while (!astNodes.isEmpty()) {
                CAstNode node = (CAstNode)astNodes.pop();
                result.addAll(SourceLocationMapper.collectTokensFrom(node, overApproximateTokens));
            }
        }
        return result;
    }

    public static synchronized void getKnownToEdge(CFAEdge edge) {
        Set<String> variables = SourceLocationMapper.getEdgeVariableNames(edge);
        Set<Integer> tokens = SourceLocationMapper.getAbsoluteTokensFromCFAEdge(edge, true);
        for (String variable : variables) {
            TreeSet variableTokens = variableRelatedTokens.get(variable);
            if (variableTokens == null) {
                variableTokens = Sets.newTreeSet();
                variableRelatedTokens.put(variable, variableTokens);
            }
            variableTokens.addAll(tokens);
        }
    }

    public static Set<String> getEdgeVariableNames(CFAEdge subject) {
        CIdExpressionCollectingVisitor visitor = new CIdExpressionCollectingVisitor();
        HashSet result = Sets.newHashSet();
        HashSet idExs = Sets.newHashSet();
        ArrayDeque edges = Queues.newArrayDeque();
        edges.add(subject);
        block10: while (!edges.isEmpty()) {
            CFAEdge edge = (CFAEdge)edges.pop();
            switch (edge.getEdgeType()) {
                case MultiEdge: {
                    edges.addAll(((MultiEdge)edge).getEdges());
                    break;
                }
                case AssumeEdge: {
                    CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                    idExs.addAll((Collection)assumeEdge.getExpression().accept(visitor));
                    break;
                }
                case CallToReturnEdge: {
                    CFunctionSummaryEdge fnSumEdge = (CFunctionSummaryEdge)edge;
                    idExs.addAll((Collection)fnSumEdge.getExpression().accept(visitor));
                    break;
                }
                case DeclarationEdge: {
                    CDeclaration decl = ((CDeclarationEdge)edge).getDeclaration();
                    if (!(decl instanceof CVariableDeclaration)) break;
                    CVariableDeclaration varDecl = (CVariableDeclaration)decl;
                    result.add(varDecl.getQualifiedName());
                    if (varDecl.getInitializer() == null) continue block10;
                    idExs.addAll((Collection)varDecl.getInitializer().accept(visitor));
                    break;
                }
                case FunctionCallEdge: {
                    CFunctionCallEdge callEdge = (CFunctionCallEdge)edge;
                    for (CExpression e : callEdge.getArguments()) {
                        idExs.addAll((Collection)e.accept(visitor));
                    }
                    continue block10;
                }
                case FunctionReturnEdge: {
                    break;
                }
                case ReturnStatementEdge: {
                    Optional<CExpression> expr = ((CReturnStatementEdge)edge).getExpression();
                    if (!expr.isPresent()) break;
                    idExs.addAll((Collection)((CExpression)expr.get()).accept(visitor));
                    break;
                }
                case StatementEdge: {
                    idExs.addAll((Collection)((CStatementEdge)edge).getStatement().accept(visitor));
                }
            }
        }
        for (CIdExpression e : idExs) {
            if (e.getDeclaration() == null) continue;
            result.add(e.getDeclaration().getQualifiedName());
        }
        return result;
    }

    public static class RowAndColumn
    implements Comparable<RowAndColumn> {
        public final int row;
        public final int column;

        public RowAndColumn(int row, int col) {
            this.row = row;
            this.column = col;
        }

        public String toString() {
            return this.row + ":" + this.column;
        }

        @Override
        public int compareTo(RowAndColumn pO) {
            if (pO.row == this.row && pO.column == this.column) {
                return 0;
            }
            if (pO.row == this.row) {
                if (pO.column > this.column) {
                    return 1;
                }
                return -1;
            }
            if (pO.row > this.row) {
                return 1;
            }
            return -1;
        }

        public int hashCode() {
            return 31 * (31 + this.column) + this.row;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RowAndColumn)) {
                return false;
            }
            RowAndColumn other = (RowAndColumn)obj;
            return this.row == other.row && this.column == other.column;
        }
    }

    public static class OffsetDescriptor
    extends FileNameDescriptor
    implements LocationDescriptor {
        public final int offset;

        public OffsetDescriptor(Optional<String> pOriginFileName, int pOffset) {
            this(pOriginFileName, pOffset, true);
        }

        public OffsetDescriptor(Optional<String> pOriginFileName, int pOffset, boolean pMatchBaseName) {
            super(pOriginFileName, pMatchBaseName);
            this.offset = pOffset;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getOriginFileName(), this.offset);
        }

        @Override
        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof OffsetDescriptor)) {
                return false;
            }
            OffsetDescriptor other = (OffsetDescriptor)pObj;
            return Objects.equals(this.getOriginFileName(), other.getOriginFileName()) && this.offset == other.offset;
        }

        @Override
        public boolean matches(FileLocation pFileLocation) {
            return super.matches(pFileLocation) && pFileLocation.getNodeOffset() <= this.offset && pFileLocation.getNodeOffset() + pFileLocation.getNodeLength() > this.offset;
        }

        @Override
        public String toString() {
            return "OFFSET " + this.offset;
        }
    }

    public static class OriginLineDescriptor
    extends FileNameDescriptor
    implements LocationDescriptor {
        public final int originLineNumber;

        public OriginLineDescriptor(Optional<String> pOriginFileName, int pOriginLineNumber) {
            this(pOriginFileName, pOriginLineNumber, true);
        }

        public OriginLineDescriptor(Optional<String> pOriginFileName, int pOriginLineNumber, boolean pMatchBaseName) {
            super(pOriginFileName, pMatchBaseName);
            this.originLineNumber = pOriginLineNumber;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getOriginFileName(), this.originLineNumber);
        }

        @Override
        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof OriginLineDescriptor)) {
                return false;
            }
            OriginLineDescriptor other = (OriginLineDescriptor)pObj;
            return Objects.equals(this.getOriginFileName(), other.getOriginFileName()) && this.originLineNumber == other.originLineNumber;
        }

        @Override
        public boolean matches(FileLocation pFileLocation) {
            return super.matches(pFileLocation) && pFileLocation.getStartingLineNumber() <= this.originLineNumber && pFileLocation.getEndingLineNumber() >= this.originLineNumber;
        }

        @Override
        public String toString() {
            return "ORIGIN STARTING LINE " + this.originLineNumber;
        }
    }

    public static class FileNameDescriptor
    implements LocationDescriptor {
        private final Optional<String> originFileName;
        private final boolean matchBaseName;

        public FileNameDescriptor(String originFileName) {
            this(originFileName, true);
        }

        public FileNameDescriptor(String originFileName, boolean matchBaseName) {
            this.originFileName = Optional.of((Object)originFileName);
            this.matchBaseName = matchBaseName;
        }

        private FileNameDescriptor(Optional<String> originFileName, boolean matchBaseName) {
            Preconditions.checkNotNull(originFileName);
            this.originFileName = originFileName;
            this.matchBaseName = matchBaseName;
        }

        @Override
        public boolean matches(FileLocation pFileLocation) {
            if (!this.originFileName.isPresent()) {
                return true;
            }
            String originFileName = (String)this.originFileName.get();
            String fileLocationFileName = pFileLocation.getFileName();
            if (this.matchBaseName) {
                originFileName = this.getBaseName(originFileName);
                fileLocationFileName = this.getBaseName(fileLocationFileName);
            }
            return originFileName.equals(fileLocationFileName);
        }

        private String getBaseName(String pOf) {
            int index = pOf.lastIndexOf(47);
            if (index == -1) {
                index = pOf.lastIndexOf(92);
            }
            if (index == -1) {
                return pOf;
            }
            return pOf.substring(index + 1);
        }

        public int hashCode() {
            return this.originFileName.hashCode();
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof FileNameDescriptor && pObj.getClass().equals(FileNameDescriptor.class)) {
                FileNameDescriptor other = (FileNameDescriptor)pObj;
                return this.originFileName.equals(other.originFileName);
            }
            return false;
        }

        public String toString() {
            return this.originFileName.isPresent() ? "FILE " + this.originFileName : "TRUE";
        }

        protected Optional<String> getOriginFileName() {
            return this.originFileName;
        }
    }

    public static interface LocationDescriptor {
        public boolean matches(FileLocation var1);
    }
}

