/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpressionCollectorVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="staticRefiner")
public abstract class StaticRefiner {
    @Option(secure=true, description="collect at most this number of assumes along a path, backwards from each target (= error) location")
    private int maxBackscanPathAssumes = 1;
    protected final LogManager logger;

    public StaticRefiner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        pConfig.inject((Object)this, StaticRefiner.class);
    }

    protected Set<CIdExpression> getVariablesOfAssume(AssumeEdge pAssume) throws CPATransferException {
        if (pAssume.getExpression() instanceof CExpression) {
            CExpression ce = (CExpression)pAssume.getExpression();
            CIdExpressionCollectorVisitor referencedVariablesVisitor = new CIdExpressionCollectorVisitor();
            ce.accept(referencedVariablesVisitor);
            return referencedVariablesVisitor.getReferencedIdExpressions();
        }
        throw new RuntimeException("Only C programming language supported!");
    }

    protected ListMultimap<CFANode, AssumeEdge> getTargetLocationAssumes(Collection<CFANode> targetNodes) {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (targetNodes.isEmpty()) {
            return result;
        }
        for (CFANode targetNode : targetNodes) {
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.add(Pair.of((Object)targetNode, (Object)0));
            HashSet<Object> explored = new HashSet<Object>();
            while (!queue.isEmpty()) {
                Pair v = (Pair)queue.pop();
                for (CFAEdge e : CFAUtils.enteringEdges((CFANode)v.getFirst())) {
                    int depthIncrease;
                    CFANode u = e.getPredecessor();
                    boolean isAssumeEdge = e instanceof AssumeEdge;
                    int n = depthIncrease = isAssumeEdge ? 1 : 0;
                    if (isAssumeEdge) {
                        AssumeEdge assume = (AssumeEdge)e;
                        if ((Integer)v.getSecond() >= this.maxBackscanPathAssumes) continue;
                        result.put((Object)targetNode, (Object)assume);
                    }
                    if (explored.contains(u)) continue;
                    queue.add(Pair.of((Object)u, (Object)((Integer)v.getSecond() + depthIncrease)));
                }
                explored.add(v.getFirst());
            }
        }
        return result;
    }
}

