/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.util.VariableClassificationBuilder;

public class VariableClassification {
    private final boolean hasRelevantNonIntAddVars;
    private final Set<String> intBoolVars;
    private final Set<String> intEqualVars;
    private final Set<String> intAddVars;
    private final Set<String> relevantVariables;
    private final Set<String> addressedVariables;
    private final Multimap<CCompositeType, String> relevantFields;
    private final Set<Partition> partitions;
    private final Set<Partition> intBoolPartitions;
    private final Set<Partition> intEqualPartitions;
    private final Set<Partition> intAddPartitions;
    private final Map<Pair<CFAEdge, Integer>, Partition> edgeToPartitions;

    VariableClassification(boolean pHasRelevantNonIntAddVars, Set<String> pIntBoolVars, Set<String> pIntEqualVars, Set<String> pIntAddVars, Set<String> pRelevantVariables, Set<String> pAddressedVariables, Multimap<CCompositeType, String> pRelevantFields, Collection<Partition> pPartitions, Set<Partition> pIntBoolPartitions, Set<Partition> pIntEqualPartitions, Set<Partition> pIntAddPartitions, Map<Pair<CFAEdge, Integer>, Partition> pEdgeToPartitions) {
        this.hasRelevantNonIntAddVars = pHasRelevantNonIntAddVars;
        this.intBoolVars = ImmutableSet.copyOf(pIntBoolVars);
        this.intEqualVars = ImmutableSet.copyOf(pIntEqualVars);
        this.intAddVars = ImmutableSet.copyOf(pIntAddVars);
        this.relevantVariables = ImmutableSet.copyOf(pRelevantVariables);
        this.addressedVariables = ImmutableSet.copyOf(pAddressedVariables);
        this.relevantFields = ImmutableSetMultimap.copyOf(pRelevantFields);
        this.partitions = ImmutableSet.copyOf(pPartitions);
        this.intBoolPartitions = ImmutableSet.copyOf(pIntBoolPartitions);
        this.intEqualPartitions = ImmutableSet.copyOf(pIntEqualPartitions);
        this.intAddPartitions = ImmutableSet.copyOf(pIntAddPartitions);
        this.edgeToPartitions = ImmutableMap.copyOf(pEdgeToPartitions);
    }

    @VisibleForTesting
    public static VariableClassification empty() {
        return new VariableClassification(false, (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Multimap<CCompositeType, String>)ImmutableSetMultimap.of(), (Collection<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Set<Partition>)ImmutableSet.of(), (Map<Pair<CFAEdge, Integer>, Partition>)ImmutableMap.of());
    }

    public boolean hasRelevantNonIntAddVars() {
        return this.hasRelevantNonIntAddVars;
    }

    public Set<String> getRelevantVariables() {
        return this.relevantVariables;
    }

    public Set<String> getAddressedVariables() {
        return this.addressedVariables;
    }

    public Multimap<CCompositeType, String> getRelevantFields() {
        return this.relevantFields;
    }

    public Set<String> getIntBoolVars() {
        return this.intBoolVars;
    }

    public Set<Partition> getIntBoolPartitions() {
        return this.intBoolPartitions;
    }

    public Set<String> getIntEqualVars() {
        return this.intEqualVars;
    }

    public Set<Partition> getIntEqualPartitions() {
        return this.intEqualPartitions;
    }

    public Set<String> getIntAddVars() {
        return this.intAddVars;
    }

    public Set<Partition> getIntAddPartitions() {
        return this.intAddPartitions;
    }

    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    public Partition getPartitionForEdge(CFAEdge edge) {
        Preconditions.checkArgument((!(edge instanceof FunctionCallEdge) ? 1 : 0) != 0, (Object)"For FunctionCallEdges, use the specific methods because they have multiple partitions");
        return this.getPartitionForEdge(edge, 0);
    }

    public Partition getPartitionForParameterOfEdge(FunctionCallEdge edge, int param) {
        Preconditions.checkElementIndex((int)param, (int)edge.getArguments().size());
        return this.getPartitionForEdge(edge, param);
    }

    public Partition getPartitionForReturnValueOfEdge(FunctionCallEdge edge) {
        return this.getPartitionForEdge(edge, -1);
    }

    private Partition getPartitionForEdge(CFAEdge edge, int index) {
        return this.edgeToPartitions.get(Pair.of((Object)edge, (Object)index));
    }

    @Deprecated
    public static String createFunctionReturnVariable(String function) {
        return VariableClassificationBuilder.createFunctionReturnVariable(function);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nIntBool  " + this.intBoolVars.size() + "\n    " + this.intBoolVars);
        str.append("\nIntEq  " + this.intEqualVars.size() + "\n    " + this.intEqualVars);
        str.append("\nIntAdd  " + this.intAddVars.size() + "\n    " + this.intAddVars);
        return str.toString();
    }

    public static class Partition {
        private final Set<String> vars = new HashSet<String>();
        private final Set<BigInteger> values = Sets.newTreeSet();
        private final Multimap<CFAEdge, Integer> edges = HashMultimap.create();
        private final Map<String, Partition> varToPartition;
        private final Map<Pair<CFAEdge, Integer>, Partition> edgeToPartition;

        Partition(Map<String, Partition> varToPartition, Map<Pair<CFAEdge, Integer>, Partition> edgeToPartition) {
            this.varToPartition = varToPartition;
            this.edgeToPartition = edgeToPartition;
        }

        public Set<String> getVars() {
            return this.vars;
        }

        public Set<BigInteger> getValues() {
            return this.values;
        }

        public Multimap<CFAEdge, Integer> getEdges() {
            return this.edges;
        }

        void add(String var) {
            this.vars.add(var);
            this.varToPartition.put(var, this);
        }

        void addValues(Set<BigInteger> newValues) {
            this.values.addAll(newValues);
        }

        void addEdge(CFAEdge edge, int index) {
            this.edges.put((Object)edge, (Object)index);
            this.edgeToPartition.put((Pair<CFAEdge, Integer>)Pair.of((Object)edge, (Object)index), this);
        }

        void merge(Partition other) {
            assert (this.varToPartition == other.varToPartition);
            this.vars.addAll(other.vars);
            this.values.addAll(other.values);
            this.edges.putAll(other.edges);
            for (String var : other.vars) {
                this.varToPartition.put(var, this);
            }
            for (Map.Entry edge : other.edges.entries()) {
                this.edgeToPartition.put((Pair<CFAEdge, Integer>)Pair.of(edge.getKey(), edge.getValue()), this);
            }
        }

        public boolean equals(Object other) {
            if (other instanceof Partition) {
                Partition p = (Partition)other;
                return this.vars == p.vars;
            }
            return false;
        }

        public int hashCode() {
            return this.vars.hashCode();
        }

        public String toString() {
            return this.vars.toString() + " --> " + Arrays.toString(this.values.toArray());
        }
    }
}

