/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.VariableClassification;

@Options(prefix="cfa.variableClassification")
public class VariableClassificationBuilder {
    @Option(secure=true, name="logfile", description="Dump variable classification to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path dumpfile = Paths.get((String)"VariableClassification.log", (String[])new String[0]);
    @Option(secure=true, description="Dump variable type mapping to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path typeMapFile = Paths.get((String)"VariableTypeMapping.txt", (String[])new String[0]);
    @Option(secure=true, description="Dump domain type statistics to a CSV file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path domainTypeStatisticsFile = null;
    @Option(secure=true, description="Print some information about the variable classification.")
    private boolean printStatsOnStartup = false;
    @Deprecated
    public static final String FUNCTION_RETURN_VARIABLE = "__retval__";
    private static final String SCOPE_SEPARATOR = "::";
    private boolean allowOneAsBooleanValue = false;
    private final Set<String> allVars = new HashSet<String>();
    private final Set<String> nonIntBoolVars = new HashSet<String>();
    private final Set<String> nonIntEqVars = new HashSet<String>();
    private final Set<String> nonIntAddVars = new HashSet<String>();
    private final Dependencies dependencies = new Dependencies();
    private final Set<String> relevantVariables = new HashSet<String>();
    private final Set<String> addressedVariables = new HashSet<String>();
    private final Multimap<VariableOrField, VariableOrField> assignments = LinkedHashMultimap.create();
    private final Multimap<CCompositeType, String> relevantFields = LinkedHashMultimap.create();
    private final CollectingLHSVisitor collectingLHSVisitor = new CollectingLHSVisitor();
    private final LogManager logger;

    public VariableClassificationBuilder(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        config.inject((Object)this);
    }

    public VariableClassification build(CFA cfa) throws UnrecognizedCCodeException {
        Preconditions.checkArgument((cfa.getLanguage() == Language.C ? 1 : 0) != 0, (Object)"VariableClassification currently only supports C");
        this.collectVars(cfa);
        this.dependencies.solve(this.nonIntBoolVars);
        this.dependencies.solve(this.nonIntEqVars);
        this.dependencies.solve(this.nonIntAddVars);
        HashSet<String> intBoolVars = new HashSet<String>();
        HashSet<String> intEqualVars = new HashSet<String>();
        HashSet<String> intAddVars = new HashSet<String>();
        HashSet<VariableClassification.Partition> intBoolPartitions = new HashSet<VariableClassification.Partition>();
        HashSet<VariableClassification.Partition> intEqualPartitions = new HashSet<VariableClassification.Partition>();
        HashSet<VariableClassification.Partition> intAddPartitions = new HashSet<VariableClassification.Partition>();
        for (String var : this.allVars) {
            if (!this.nonIntBoolVars.contains(var)) {
                intBoolVars.add(var);
                intBoolPartitions.add(this.dependencies.getPartitionForVar(var));
                continue;
            }
            if (!this.nonIntEqVars.contains(var)) {
                intEqualVars.add(var);
                intEqualPartitions.add(this.dependencies.getPartitionForVar(var));
                continue;
            }
            if (this.nonIntAddVars.contains(var)) continue;
            intAddVars.add(var);
            intAddPartitions.add(this.dependencies.getPartitionForVar(var));
        }
        this.propagateRelevancy();
        for (String var : this.allVars) {
            this.dependencies.addVar(var);
        }
        boolean hasRelevantNonIntAddVars = !Sets.intersection(this.relevantVariables, this.nonIntAddVars).isEmpty();
        VariableClassification result = new VariableClassification(hasRelevantNonIntAddVars, intBoolVars, intEqualVars, intAddVars, this.relevantVariables, this.addressedVariables, this.relevantFields, this.dependencies.partitions, intBoolPartitions, intEqualPartitions, intAddPartitions, this.dependencies.edgeToPartition);
        if (this.printStatsOnStartup) {
            this.printStats(result);
        }
        if (this.dumpfile != null) {
            try (Writer w = Files.openOutputFile((Path)this.dumpfile, (FileWriteMode[])new FileWriteMode[0]);){
                w.append("IntBool\n\n");
                w.append(((Object)intBoolVars).toString());
                w.append("\n\nIntEq\n\n");
                w.append(((Object)intEqualVars).toString());
                w.append("\n\nIntAdd\n\n");
                w.append(((Object)intAddVars).toString());
                w.append("\n\nALL\n\n");
                w.append(this.allVars.toString());
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable classification to file");
            }
        }
        if (this.typeMapFile != null) {
            this.dumpVariableTypeMapping(this.typeMapFile, result);
        }
        if (this.domainTypeStatisticsFile != null) {
            this.dumpDomainTypeStatistics(this.domainTypeStatisticsFile, result);
        }
        return result;
    }

    private void dumpDomainTypeStatistics(Path pDomainTypeStatisticsFile, VariableClassification vc) {
        try (Writer w = Files.openOutputFile((Path)pDomainTypeStatisticsFile, (FileWriteMode[])new FileWriteMode[0]);
             PrintWriter p = new PrintWriter(w);){
            int col;
            Object[][] statMapping = new Object[][]{{"intBoolVars", vc.getIntBoolVars().size()}, {"intEqualVars", vc.getIntEqualVars().size()}, {"intAddVars", vc.getIntAddVars().size()}, {"allVars", this.allVars.size()}, {"intBoolVarsRelevant", this.countNumberOfRelevantVars(vc.getIntBoolVars())}, {"intEqualVarsRelevant", this.countNumberOfRelevantVars(vc.getIntEqualVars())}, {"intAddVarsRelevant", this.countNumberOfRelevantVars(vc.getIntAddVars())}, {"allVarsRelevant", this.countNumberOfRelevantVars(this.allVars)}};
            for (col = 0; col < statMapping.length; ++col) {
                p.print(statMapping[col][0]);
                if (col == statMapping.length - 1) continue;
                p.print("\t");
            }
            p.print("\n");
            for (col = 0; col < statMapping.length; ++col) {
                p.print(statMapping[col][1]);
                if (col == statMapping.length - 1) continue;
                p.print("\t");
            }
            p.print("\n");
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable classification statistics to file");
        }
    }

    private void dumpVariableTypeMapping(Path target, VariableClassification vc) {
        try (Writer w = Files.openOutputFile((Path)target, (FileWriteMode[])new FileWriteMode[0]);){
            for (String var : this.allVars) {
                byte type = 0;
                if (vc.getIntBoolVars().contains(var)) {
                    type = (byte)(type + 7);
                } else if (vc.getIntEqualVars().contains(var)) {
                    type = (byte)(type + 6);
                } else if (vc.getIntAddVars().contains(var)) {
                    type = (byte)(type + 4);
                }
                w.append(String.format("%s\t%d%n", var, type));
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write variable type mapping to file");
        }
    }

    private void printStats(VariableClassification vc) {
        int numOfBooleans = 0;
        for (VariableClassification.Partition p : vc.getIntEqualPartitions()) {
            numOfBooleans += p.getVars().size();
        }
        assert (numOfBooleans == vc.getIntBoolVars().size());
        int numOfIntEquals = 0;
        for (VariableClassification.Partition p : vc.getIntEqualPartitions()) {
            numOfIntEquals += p.getVars().size();
        }
        assert (numOfIntEquals == vc.getIntEqualVars().size());
        int numOfIntAdds = 0;
        for (VariableClassification.Partition p : vc.getIntAddPartitions()) {
            numOfIntAdds += p.getVars().size();
        }
        assert (numOfIntAdds == vc.getIntAddVars().size());
        String prefix = "\nVC ";
        StringBuilder str = new StringBuilder("VariableClassification Statistics\n");
        Joiner.on((String)"\nVC ").appendTo(str, (Object[])new String[]{"---------------------------------", "number of boolean vars:  " + numOfBooleans, "number of intEq vars:    " + numOfIntEquals, "number of intAdd vars:   " + numOfIntAdds, "number of all vars:      " + this.allVars.size(), "number of addr. vars:    " + this.addressedVariables.size(), "number of intBool partitions:  " + vc.getIntBoolPartitions().size(), "number of intEq partitions:    " + vc.getIntEqualPartitions().size(), "number of intAdd partitions:   " + vc.getIntAddPartitions().size(), "number of all partitions:      " + this.dependencies.partitions.size()});
        str.append("\n---------------------------------\n");
        this.logger.log(Level.INFO, new Object[]{str.toString()});
    }

    private int countNumberOfRelevantVars(Set<String> ofVars) {
        return Sets.intersection(ofVars, this.relevantVariables).size();
    }

    private void collectVars(CFA cfa) throws UnrecognizedCCodeException {
        Collection<CFANode> nodes = cfa.getAllNodes();
        for (CFANode node : nodes) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                this.handleEdge(edge, cfa);
            }
        }
    }

    private void propagateRelevancy() {
        ArrayDeque<VariableOrField> queue = new ArrayDeque<VariableOrField>(this.relevantVariables.size() + this.relevantFields.size());
        for (String relevantVariable : this.relevantVariables) {
            queue.add(VariableOrField.newVariable(relevantVariable));
        }
        for (Map.Entry relevantField : this.relevantFields.entries()) {
            queue.add(VariableOrField.newField((CCompositeType)relevantField.getKey(), (String)relevantField.getValue()));
        }
        while (!queue.isEmpty()) {
            VariableOrField relevantVariableOrField = (VariableOrField)queue.poll();
            for (VariableOrField variableOrField : this.assignments.get((Object)relevantVariableOrField)) {
                VariableOrField.Variable variable = variableOrField.asVariable();
                VariableOrField.Field field = variableOrField.asField();
                assert (variable != null || field != null) : "Sum type match failure: neither variable nor field!";
                if (variable != null && !this.relevantVariables.contains(variable.getScopedName())) {
                    this.relevantVariables.add(variable.getScopedName());
                    queue.add(variable);
                    continue;
                }
                if (field == null || this.relevantFields.containsEntry((Object)field.getCompositeType(), (Object)field.getName())) continue;
                this.relevantFields.put((Object)field.getCompositeType(), (Object)field.getName());
                queue.add(field);
            }
        }
    }

    private static CCompositeType getCanonicalFieldOwnerType(CFieldReference fieldReference) {
        CType fieldOwnerType = fieldReference.getFieldOwner().getExpressionType().getCanonicalType();
        if (fieldOwnerType instanceof CPointerType) {
            fieldOwnerType = ((CPointerType)fieldOwnerType).getType();
        }
        assert (fieldOwnerType instanceof CCompositeType) : "Field owner should have composite type, but the field-owner type of expression " + fieldReference + " in " + fieldReference.getFileLocation() + " is " + fieldOwnerType + ", which is a " + fieldOwnerType.getClass().getSimpleName() + ".";
        CCompositeType compositeType = (CCompositeType)fieldOwnerType;
        if (compositeType.isConst() || compositeType.isVolatile()) {
            return new CCompositeType(false, false, compositeType.getKind(), compositeType.getMembers(), compositeType.getName(), compositeType.getOrigName());
        }
        return compositeType;
    }

    private void handleEdge(CFAEdge edge, CFA cfa) throws UnrecognizedCCodeException {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                CExpression exp = ((CAssumeEdge)edge).getExpression();
                CFANode pre = edge.getPredecessor();
                VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
                Set<String> vars = exp.accept(dcv);
                if (vars != null) {
                    this.allVars.addAll(vars);
                    this.dependencies.addAll(vars, dcv.getValues(), edge, 0);
                }
                exp.accept(new BoolCollectingVisitor(pre));
                exp.accept(new IntEqualCollectingVisitor(pre));
                exp.accept(new IntAddCollectingVisitor(pre));
                exp.accept(new CollectingRHSVisitor(null));
                break;
            }
            case DeclarationEdge: {
                this.handleDeclarationEdge((CDeclarationEdge)edge);
                break;
            }
            case StatementEdge: {
                CStatement statement = ((CStatementEdge)edge).getStatement();
                if (statement instanceof CAssignment) {
                    this.handleAssignment(edge, (CAssignment)statement, cfa);
                    break;
                }
                if (!(statement instanceof CFunctionCallStatement)) break;
                this.handleExternalFunctionCall(edge, ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions());
                ((CFunctionCallStatement)statement).getFunctionCallExpression().accept(new CollectingRHSVisitor(null));
                break;
            }
            case FunctionCallEdge: {
                this.handleFunctionCallEdge((CFunctionCallEdge)edge);
                break;
            }
            case FunctionReturnEdge: {
                Optional<CVariableDeclaration> returnVar = ((CFunctionReturnEdge)edge).getFunctionEntry().getReturnVariable();
                if (!returnVar.isPresent()) break;
                String scopedVarName = ((CVariableDeclaration)returnVar.get()).getQualifiedName();
                this.dependencies.addVar(scopedVarName);
                VariableClassification.Partition partition = this.dependencies.getPartitionForVar(scopedVarName);
                partition.addEdge(edge, 0);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnStatement = (CReturnStatementEdge)edge;
                if (!returnStatement.asAssignment().isPresent()) break;
                this.handleAssignment(edge, (CAssignment)returnStatement.asAssignment().get(), cfa);
                break;
            }
            case MultiEdge: {
                for (CFAEdge innerEdge : (MultiEdge)edge) {
                    this.handleEdge(innerEdge, cfa);
                }
                break;
            }
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCCodeException("Unknown edgeType: " + (Object)((Object)edge.getEdgeType()), edge);
            }
        }
    }

    private void handleDeclarationEdge(CDeclarationEdge edge) throws UnrecognizedCCodeException {
        CDeclaration declaration = edge.getDeclaration();
        if (!(declaration instanceof CVariableDeclaration)) {
            return;
        }
        CVariableDeclaration vdecl = (CVariableDeclaration)declaration;
        String varName = vdecl.getQualifiedName();
        this.allVars.add(varName);
        HashSet var = Sets.newHashSetWithExpectedSize((int)1);
        var.add(varName);
        this.dependencies.addAll(var, new HashSet<BigInteger>(), edge, 0);
        if (!(vdecl.getType() instanceof CSimpleType)) {
            this.nonIntBoolVars.add(varName);
            this.nonIntEqVars.add(varName);
            this.nonIntAddVars.add(varName);
        }
        CInitializer initializer = vdecl.getInitializer();
        List<CExpressionAssignmentStatement> l = CInitializers.convertToAssignments(vdecl, edge);
        for (CExpressionAssignmentStatement init : l) {
            CLeftHandSide lhsExpression = init.getLeftHandSide();
            VariableOrField lhs = lhsExpression.accept(this.collectingLHSVisitor);
            CExpression rhs = init.getRightHandSide();
            rhs.accept(new CollectingRHSVisitor(lhs));
        }
        if (initializer == null || !(initializer instanceof CInitializerExpression)) {
            return;
        }
        CExpression exp = ((CInitializerExpression)initializer).getExpression();
        if (exp == null) {
            return;
        }
        this.handleExpression(edge, exp, varName, VariableOrField.newVariable(varName));
    }

    private void handleAssignment(CFAEdge edge, CAssignment assignment, CFA cfa) throws UnrecognizedCCodeException {
        CRightHandSide rhs = assignment.getRightHandSide();
        CLeftHandSide lhs = assignment.getLeftHandSide();
        String function = VariableClassificationBuilder.isGlobal(lhs) ? null : edge.getPredecessor().getFunctionName();
        String varName = VariableClassificationBuilder.scopeVar(function, lhs.toASTString());
        if (!(lhs instanceof CIdExpression) || !(lhs.getExpressionType() instanceof CSimpleType)) {
            this.nonIntBoolVars.add(varName);
            this.nonIntEqVars.add(varName);
            this.nonIntAddVars.add(varName);
        }
        this.dependencies.addVar(varName);
        VariableOrField lhsVariableOrField = lhs.accept(this.collectingLHSVisitor);
        if (rhs instanceof CExpression) {
            this.handleExpression(edge, (CExpression)rhs, varName, lhsVariableOrField);
        } else if (rhs instanceof CFunctionCallExpression) {
            CFunctionCallExpression func = (CFunctionCallExpression)rhs;
            String functionName = func.getFunctionNameExpression().toASTString();
            if (cfa.getAllFunctionNames().contains(functionName)) {
                Optional<? extends AVariableDeclaration> returnVariable = cfa.getFunctionHead(functionName).getReturnVariable();
                if (!returnVariable.isPresent()) {
                    throw new UnrecognizedCCodeException("Void function " + functionName + " used in assignment", edge, assignment);
                }
                String returnVar = ((AVariableDeclaration)returnVariable.get()).getQualifiedName();
                this.allVars.add(returnVar);
                this.allVars.add(varName);
                this.dependencies.add(returnVar, varName);
            } else {
                VariableClassification.Partition partition = this.dependencies.getPartitionForVar(varName);
                partition.addEdge(edge, -1);
            }
            rhs.accept(new CollectingRHSVisitor(lhsVariableOrField));
            this.handleExternalFunctionCall(edge, func.getParameterExpressions());
        } else {
            throw new UnrecognizedCCodeException("unhandled assignment", edge, assignment);
        }
    }

    private void handleExternalFunctionCall(CFAEdge edge, List<CExpression> params) {
        for (int i = 0; i < params.size(); ++i) {
            CExpression param = params.get(i);
            if (param instanceof CUnaryExpression && CUnaryExpression.UnaryOperator.AMPER == ((CUnaryExpression)param).getOperator() && ((CUnaryExpression)param).getOperand() instanceof CIdExpression) {
                CIdExpression id = (CIdExpression)((CUnaryExpression)param).getOperand();
                String varName = id.getDeclaration().getQualifiedName();
                this.dependencies.addVar(varName);
                VariableClassification.Partition partition = this.dependencies.getPartitionForVar(varName);
                partition.addEdge(edge, i);
                continue;
            }
            CFANode pre = edge.getPredecessor();
            VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
            Set<String> vars = param.accept(dcv);
            if (vars != null) {
                this.allVars.addAll(vars);
                this.dependencies.addAll(vars, dcv.getValues(), edge, i);
            }
            param.accept(new BoolCollectingVisitor(pre));
            param.accept(new IntEqualCollectingVisitor(pre));
            param.accept(new IntAddCollectingVisitor(pre));
        }
    }

    private void handleFunctionCallEdge(CFunctionCallEdge edge) {
        List<CExpression> args = edge.getArguments();
        List<CParameterDeclaration> params = edge.getSuccessor().getFunctionParameters();
        assert (args.size() >= params.size());
        for (int i = 0; i < params.size(); ++i) {
            CParameterDeclaration param = params.get(i);
            String varName = param.getQualifiedName();
            if (!(param.getType() instanceof CSimpleType)) {
                this.nonIntBoolVars.add(varName);
                this.nonIntEqVars.add(varName);
                this.nonIntAddVars.add(varName);
            }
            this.handleExpression(edge, args.get(i), varName, i, VariableOrField.newVariable(varName));
        }
        CFunctionSummaryEdge func = edge.getSummaryEdge();
        CFunctionCall statement = func.getExpression();
        Optional<CVariableDeclaration> returnVar = edge.getSuccessor().getReturnVariable();
        if (returnVar.isPresent()) {
            String scopedRetVal = ((CVariableDeclaration)returnVar.get()).getQualifiedName();
            if (statement instanceof CFunctionCallAssignmentStatement) {
                CFunctionCallAssignmentStatement call = (CFunctionCallAssignmentStatement)statement;
                CLeftHandSide lhs = call.getLeftHandSide();
                String function = VariableClassificationBuilder.isGlobal(lhs) ? null : edge.getPredecessor().getFunctionName();
                String varName = VariableClassificationBuilder.scopeVar(function, lhs.toASTString());
                this.allVars.add(scopedRetVal);
                this.allVars.add(varName);
                this.dependencies.add(scopedRetVal, varName);
                VariableOrField lhsVariableOrField = lhs.accept(this.collectingLHSVisitor);
                this.assignments.put((Object)lhsVariableOrField, (Object)VariableOrField.newVariable(scopedRetVal));
            } else if (statement instanceof CFunctionCallStatement) {
                this.dependencies.addVar(scopedRetVal);
            }
        }
    }

    private void handleExpression(CFAEdge edge, CExpression exp, String varName, VariableOrField lhs) {
        this.handleExpression(edge, exp, varName, 0, lhs);
    }

    private void handleExpression(CFAEdge edge, CExpression exp, String varName, int id, VariableOrField lhs) {
        CFANode pre = edge.getPredecessor();
        VariablesCollectingVisitor dcv = new VariablesCollectingVisitor(pre);
        HashSet vars = exp.accept(dcv);
        if (vars == null) {
            vars = Sets.newHashSetWithExpectedSize((int)1);
        }
        vars.add(varName);
        this.allVars.addAll(vars);
        this.dependencies.addAll(vars, dcv.getValues(), edge, id);
        BoolCollectingVisitor bcv = new BoolCollectingVisitor(pre);
        Set<String> possibleBoolean = exp.accept(bcv);
        this.handleResult(varName, possibleBoolean, this.nonIntBoolVars);
        IntEqualCollectingVisitor ncv = new IntEqualCollectingVisitor(pre);
        Set<String> possibleIntEqualVars = exp.accept(ncv);
        this.handleResult(varName, possibleIntEqualVars, this.nonIntEqVars);
        IntAddCollectingVisitor icv = new IntAddCollectingVisitor(pre);
        Set<String> possibleIntAddVars = exp.accept(icv);
        this.handleResult(varName, possibleIntAddVars, this.nonIntAddVars);
        exp.accept(new CollectingRHSVisitor(lhs));
    }

    private void handleResult(String varName, Collection<String> possibleVars, Collection<String> notPossibleVars) {
        if (possibleVars == null) {
            notPossibleVars.add(varName);
        }
    }

    private static String scopeVar(@Nullable String function, String var) {
        return function == null ? var : function + SCOPE_SEPARATOR + var;
    }

    private static boolean isGlobal(CExpression exp) {
        CSimpleDeclaration decl;
        if (exp instanceof CIdExpression && (decl = ((CIdExpression)exp).getDeclaration()) instanceof CDeclaration) {
            return ((CDeclaration)decl).isGlobal();
        }
        return false;
    }

    @Deprecated
    public static String createFunctionReturnVariable(String function) {
        return function + SCOPE_SEPARATOR + FUNCTION_RETURN_VARIABLE;
    }

    public static BigInteger getNumber(CExpression exp) {
        if (exp instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)exp).getValue();
        }
        if (exp instanceof CUnaryExpression) {
            CUnaryExpression unExp = (CUnaryExpression)exp;
            BigInteger value = VariableClassificationBuilder.getNumber(unExp.getOperand());
            if (value == null) {
                return null;
            }
            switch (unExp.getOperator()) {
                case MINUS: {
                    return value.negate();
                }
            }
            return null;
        }
        if (exp instanceof CCastExpression) {
            return VariableClassificationBuilder.getNumber(((CCastExpression)exp).getOperand());
        }
        return null;
    }

    private static boolean isNestedBinaryExp(CExpression exp) {
        if (exp instanceof CBinaryExpression) {
            return true;
        }
        if (exp instanceof CCastExpression) {
            return VariableClassificationBuilder.isNestedBinaryExp(((CCastExpression)exp).getOperand());
        }
        return false;
    }

    private void addVariableOrField(@Nullable VariableOrField lhs, VariableOrField rhs) {
        if (lhs != null) {
            this.assignments.put((Object)lhs, (Object)rhs);
        } else {
            VariableOrField.Variable variable = rhs.asVariable();
            VariableOrField.Field field = rhs.asField();
            if (variable != null) {
                this.relevantVariables.add(variable.getScopedName());
            } else {
                this.relevantFields.put((Object)field.getCompositeType(), (Object)field.getName());
            }
        }
    }

    private static class VariableOrField {
        private VariableOrField() {
        }

        public static Variable newVariable(String scopedName) {
            return new Variable(scopedName);
        }

        public static Field newField(@Nonnull CCompositeType composite, @Nonnull String name) {
            return new Field(composite, name);
        }

        @Nullable
        public Variable asVariable() {
            if (this instanceof Variable) {
                return (Variable)this;
            }
            return null;
        }

        @Nullable
        public Field asField() {
            if (this instanceof Field) {
                return (Field)this;
            }
            return null;
        }

        private static class Field
        extends VariableOrField {
            @Nonnull
            private CCompositeType composite;
            @Nonnull
            private String name;

            private Field(CCompositeType composite, String name) {
                this.composite = composite;
                this.name = name;
            }

            public CCompositeType getCompositeType() {
                return this.composite;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return this.composite + VariableClassificationBuilder.SCOPE_SEPARATOR + this.name;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Field)) {
                    return false;
                }
                Field other = (Field)o;
                return this.composite.equals(other.composite) && this.name.equals(other.name);
            }

            public int hashCode() {
                int prime = 67;
                return 67 * this.composite.hashCode() + this.name.hashCode();
            }
        }

        private static class Variable
        extends VariableOrField {
            @Nonnull
            private final String scopedName;

            private Variable(@Nonnull String scopedName) {
                this.scopedName = scopedName;
            }

            @Nonnull
            public String getScopedName() {
                return this.scopedName;
            }

            public String toString() {
                return this.getScopedName();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Variable)) {
                    return false;
                }
                Variable other = (Variable)o;
                return this.scopedName.equals(other.scopedName);
            }

            public int hashCode() {
                return this.scopedName.hashCode();
            }
        }
    }

    private class CollectingRHSVisitor
    extends DefaultCExpressionVisitor<Void, RuntimeException>
    implements CRightHandSideVisitor<Void, RuntimeException> {
        @Nullable
        private final VariableOrField lhs;
        private boolean addressed = false;

        CollectingRHSVisitor(VariableOrField pLhs) {
            this.lhs = pLhs;
        }

        @Override
        public Void visit(CArraySubscriptExpression e) {
            CollectingRHSVisitor arrayExprVisitor = new CollectingRHSVisitor(null);
            arrayExprVisitor.addressed = true;
            e.getArrayExpression().accept(arrayExprVisitor);
            return e.getSubscriptExpression().accept(this);
        }

        @Override
        public Void visit(CFieldReference e) {
            CCompositeType compositeType = VariableClassificationBuilder.getCanonicalFieldOwnerType(e);
            VariableClassificationBuilder.this.addVariableOrField(this.lhs, VariableOrField.newField(compositeType, e.getFieldName()));
            return e.getFieldOwner().accept(this);
        }

        @Override
        public Void visit(CBinaryExpression e) {
            e.getOperand1().accept(this);
            return e.getOperand2().accept(this);
        }

        @Override
        public Void visit(CUnaryExpression e) {
            if (e.getOperator() != CUnaryExpression.UnaryOperator.AMPER) {
                return e.getOperand().accept(this);
            }
            this.addressed = true;
            e.getOperand().accept(this);
            this.addressed = false;
            return null;
        }

        @Override
        public Void visit(CPointerExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CComplexCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CIdExpression e) {
            VariableOrField.Variable variable = VariableOrField.newVariable(e.getDeclaration().getQualifiedName());
            VariableClassificationBuilder.this.addVariableOrField(this.lhs, variable);
            if (this.addressed) {
                VariableClassificationBuilder.this.addressedVariables.add(variable.getScopedName());
            }
            return null;
        }

        @Override
        public Void visit(CFunctionCallExpression e) {
            for (CExpression param : e.getParameterExpressions()) {
                param.accept(this);
            }
            return null;
        }

        @Override
        protected Void visitDefault(CExpression e) {
            return null;
        }
    }

    private class CollectingLHSVisitor
    extends DefaultCExpressionVisitor<VariableOrField, RuntimeException> {
        private CollectingLHSVisitor() {
        }

        @Override
        public VariableOrField visit(CArraySubscriptExpression e) {
            VariableOrField result = e.getArrayExpression().accept(this);
            e.getSubscriptExpression().accept(new CollectingRHSVisitor(result));
            return result;
        }

        @Override
        public VariableOrField visit(CFieldReference e) {
            CCompositeType compositeType = VariableClassificationBuilder.getCanonicalFieldOwnerType(e);
            VariableOrField.Field result = VariableOrField.newField(compositeType, e.getFieldName());
            if (e.isPointerDereference()) {
                e.getFieldOwner().accept(new CollectingRHSVisitor(result));
            } else {
                e.getFieldOwner().accept(this);
            }
            return result;
        }

        @Override
        public VariableOrField visit(CPointerExpression e) {
            e.getOperand().accept(new CollectingRHSVisitor(null));
            return null;
        }

        @Override
        public VariableOrField visit(CComplexCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public VariableOrField visit(CCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public VariableOrField visit(CIdExpression e) {
            return VariableOrField.newVariable(e.getDeclaration().getQualifiedName());
        }

        @Override
        protected VariableOrField visitDefault(CExpression e) {
            throw new IllegalArgumentException("The expression should not occur in the left hand side");
        }
    }

    private class IntAddCollectingVisitor
    extends VariablesCollectingVisitor {
        public IntAddCollectingVisitor(CFANode pre) {
            super(pre);
        }

        @Override
        public Set<String> visit(CCastExpression exp) {
            return exp.getOperand().accept(this);
        }

        @Override
        public Set<String> visit(CFieldReference exp) {
            VariableClassificationBuilder.this.nonIntAddVars.addAll(super.visit(exp));
            return null;
        }

        @Override
        public Set<String> visit(CBinaryExpression exp) {
            Set<String> operand1 = exp.getOperand1().accept(this);
            Set<String> operand2 = exp.getOperand2().accept(this);
            if (operand1 == null || operand2 == null) {
                if (operand1 != null) {
                    VariableClassificationBuilder.this.nonIntAddVars.addAll(operand1);
                }
                if (operand2 != null) {
                    VariableClassificationBuilder.this.nonIntAddVars.addAll(operand2);
                }
                return null;
            }
            switch (exp.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case PLUS: 
                case MINUS: 
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case BINARY_AND: 
                case BINARY_XOR: 
                case BINARY_OR: {
                    operand1.addAll(operand2);
                    return operand1;
                }
            }
            VariableClassificationBuilder.this.nonIntAddVars.addAll(operand1);
            VariableClassificationBuilder.this.nonIntAddVars.addAll(operand2);
            return null;
        }

        @Override
        public Set<String> visit(CIntegerLiteralExpression exp) {
            return new HashSet<String>(0);
        }

        @Override
        public Set<String> visit(CUnaryExpression exp) {
            Set<String> inner = exp.getOperand().accept(this);
            if (inner == null) {
                return null;
            }
            if (exp.getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
                return inner;
            }
            VariableClassificationBuilder.this.nonIntAddVars.addAll(inner);
            return null;
        }

        @Override
        public Set<String> visit(CPointerExpression exp) {
            Set<String> inner = exp.getOperand().accept(this);
            if (inner == null) {
                return null;
            }
            VariableClassificationBuilder.this.nonIntAddVars.addAll(inner);
            return null;
        }
    }

    private class IntEqualCollectingVisitor
    extends VariablesCollectingVisitor {
        public IntEqualCollectingVisitor(CFANode pre) {
            super(pre);
        }

        @Override
        public Set<String> visit(CCastExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
            if (val == null) {
                return exp.getOperand().accept(this);
            }
            return new HashSet<String>(0);
        }

        @Override
        public Set<String> visit(CFieldReference exp) {
            VariableClassificationBuilder.this.nonIntEqVars.addAll(super.visit(exp));
            return null;
        }

        @Override
        public Set<String> visit(CBinaryExpression exp) {
            BigInteger val1 = VariableClassificationBuilder.getNumber(exp.getOperand1());
            Set<Object> operand1 = val1 == null ? exp.getOperand1().accept(this) : new HashSet(0);
            BigInteger val2 = VariableClassificationBuilder.getNumber(exp.getOperand2());
            Set<Object> operand2 = val2 == null ? exp.getOperand2().accept(this) : new HashSet(0);
            if (operand1 == null || operand2 == null) {
                if (operand1 != null) {
                    VariableClassificationBuilder.this.nonIntEqVars.addAll(operand1);
                }
                if (operand2 != null) {
                    VariableClassificationBuilder.this.nonIntEqVars.addAll(operand2);
                }
                return null;
            }
            switch (exp.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: {
                    operand1.addAll(operand2);
                    return operand1;
                }
            }
            VariableClassificationBuilder.this.nonIntEqVars.addAll(operand1);
            VariableClassificationBuilder.this.nonIntEqVars.addAll(operand2);
            return null;
        }

        @Override
        public Set<String> visit(CIntegerLiteralExpression exp) {
            return new HashSet<String>(0);
        }

        @Override
        public Set<String> visit(CUnaryExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp);
            if (val != null) {
                return new HashSet<String>(0);
            }
            Set<String> inner = exp.getOperand().accept(this);
            if (VariableClassificationBuilder.isNestedBinaryExp(exp)) {
                return inner;
            }
            if (inner != null) {
                VariableClassificationBuilder.this.nonIntEqVars.addAll(inner);
            }
            return null;
        }

        @Override
        public Set<String> visit(CPointerExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp);
            if (val != null) {
                return new HashSet<String>(0);
            }
            Set<String> inner = exp.getOperand().accept(this);
            if (VariableClassificationBuilder.isNestedBinaryExp(exp)) {
                return inner;
            }
            if (inner == null) {
                return null;
            }
            VariableClassificationBuilder.this.nonIntEqVars.addAll(inner);
            return null;
        }
    }

    private class BoolCollectingVisitor
    extends VariablesCollectingVisitor {
        public BoolCollectingVisitor(CFANode pre) {
            super(pre);
        }

        @Override
        public Set<String> visit(CFieldReference exp) {
            VariableClassificationBuilder.this.nonIntBoolVars.addAll(super.visit(exp));
            return null;
        }

        @Override
        public Set<String> visit(CBinaryExpression exp) {
            Set<String> operand1 = exp.getOperand1().accept(this);
            Set<String> operand2 = exp.getOperand2().accept(this);
            if (operand1 == null || operand2 == null) {
                if (operand1 != null) {
                    VariableClassificationBuilder.this.nonIntBoolVars.addAll(operand1);
                }
                if (operand2 != null) {
                    VariableClassificationBuilder.this.nonIntBoolVars.addAll(operand2);
                }
                return null;
            }
            switch (exp.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: {
                    if (!operand1.isEmpty() && !operand2.isEmpty()) break;
                    operand1.addAll(operand2);
                    return operand1;
                }
            }
            VariableClassificationBuilder.this.nonIntBoolVars.addAll(operand1);
            VariableClassificationBuilder.this.nonIntBoolVars.addAll(operand2);
            return null;
        }

        @Override
        public Set<String> visit(CIntegerLiteralExpression exp) {
            BigInteger value = exp.getValue();
            if (BigInteger.ZERO.equals(value) || VariableClassificationBuilder.this.allowOneAsBooleanValue && BigInteger.ONE.equals(value)) {
                return new HashSet<String>(0);
            }
            return null;
        }

        @Override
        public Set<String> visit(CUnaryExpression exp) {
            Set<String> inner = exp.getOperand().accept(this);
            if (inner == null) {
                return null;
            }
            VariableClassificationBuilder.this.nonIntBoolVars.addAll(inner);
            return null;
        }

        @Override
        public Set<String> visit(CPointerExpression exp) {
            Set<String> inner = exp.getOperand().accept(this);
            if (inner == null) {
                return null;
            }
            VariableClassificationBuilder.this.nonIntBoolVars.addAll(inner);
            return null;
        }
    }

    private static class Dependencies {
        private final List<VariableClassification.Partition> partitions = Lists.newArrayList();
        private final Map<String, VariableClassification.Partition> varToPartition = Maps.newHashMap();
        private final Map<Pair<CFAEdge, Integer>, VariableClassification.Partition> edgeToPartition = Maps.newHashMap();

        private Dependencies() {
        }

        public VariableClassification.Partition getPartitionForVar(String var) {
            return this.varToPartition.get(var);
        }

        public void add(String var1, String var2) {
            VariableClassification.Partition partition1 = this.varToPartition.get(var1);
            VariableClassification.Partition partition2 = this.varToPartition.get(var2);
            if (partition1 != null && partition2 != null) {
                if (this.partitions.lastIndexOf(partition1) > this.partitions.lastIndexOf(partition2)) {
                    VariableClassification.Partition tmp = partition2;
                    partition2 = partition1;
                    partition1 = tmp;
                }
                if (!partition1.equals(partition2)) {
                    partition1.merge(partition2);
                    this.partitions.remove(partition2);
                }
            } else if (partition1 != null) {
                partition1.add(var2);
            } else if (partition2 != null) {
                partition2.add(var1);
            } else {
                VariableClassification.Partition partition = new VariableClassification.Partition(this.varToPartition, this.edgeToPartition);
                partition.add(var1);
                partition.add(var2);
                this.partitions.add(partition);
            }
        }

        public void addAll(Collection<String> vars, Set<BigInteger> values, CFAEdge edge, int index) {
            if (vars == null || vars.isEmpty()) {
                return;
            }
            Iterator<String> iter = vars.iterator();
            String var = iter.next();
            this.addVar(var);
            while (iter.hasNext()) {
                this.add(var, iter.next());
            }
            VariableClassification.Partition partition = this.getPartitionForVar(var);
            partition.addValues(values);
            partition.addEdge(edge, index);
        }

        public void addVar(String var) {
            if (!this.varToPartition.containsKey(var)) {
                VariableClassification.Partition partition = new VariableClassification.Partition(this.varToPartition, this.edgeToPartition);
                partition.add(var);
                this.partitions.add(partition);
            }
        }

        public void solve(Set<String> vars) {
            for (VariableClassification.Partition partition : this.partitions) {
                if (Sets.intersection(partition.getVars(), vars).isEmpty()) continue;
                vars.addAll(partition.getVars());
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder("[");
            Joiner.on((String)",\n").appendTo(str, this.partitions);
            str.append("]\n\n");
            return str.toString();
        }
    }

    private static class VariablesCollectingVisitor
    implements CExpressionVisitor<Set<String>, RuntimeException> {
        private CFANode predecessor;
        private Set<BigInteger> values = new TreeSet<BigInteger>();

        public VariablesCollectingVisitor(CFANode pre) {
            this.predecessor = pre;
        }

        public Set<BigInteger> getValues() {
            return this.values;
        }

        @Override
        public Set<String> visit(CArraySubscriptExpression exp) {
            return null;
        }

        @Override
        public Set<String> visit(CBinaryExpression exp) {
            Set<String> operand2;
            Set<String> operand1;
            BigInteger val1 = VariableClassificationBuilder.getNumber(exp.getOperand1());
            if (val1 == null) {
                operand1 = exp.getOperand1().accept(this);
            } else {
                this.values.add(val1);
                operand1 = null;
            }
            BigInteger val2 = VariableClassificationBuilder.getNumber(exp.getOperand2());
            if (val2 == null) {
                operand2 = exp.getOperand2().accept(this);
            } else {
                this.values.add(val2);
                operand2 = null;
            }
            if (operand1 == null) {
                return operand2;
            }
            if (operand2 == null) {
                return operand1;
            }
            operand1.addAll(operand2);
            return operand1;
        }

        @Override
        public Set<String> visit(CCastExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
            if (val == null) {
                return exp.getOperand().accept(this);
            }
            this.values.add(val);
            return null;
        }

        @Override
        public Set<String> visit(CComplexCastExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp.getOperand());
            if (val == null) {
                return exp.getOperand().accept(this);
            }
            this.values.add(val);
            return null;
        }

        @Override
        public Set<String> visit(CFieldReference exp) {
            String varName = exp.toASTString();
            String function = VariableClassificationBuilder.isGlobal(exp) ? "" : this.predecessor.getFunctionName();
            HashSet ret = Sets.newHashSetWithExpectedSize((int)1);
            ret.add(VariableClassificationBuilder.scopeVar(function, varName));
            return ret;
        }

        @Override
        public Set<String> visit(CIdExpression exp) {
            HashSet ret = Sets.newHashSetWithExpectedSize((int)1);
            ret.add(exp.getDeclaration().getQualifiedName());
            return ret;
        }

        @Override
        public Set<String> visit(CCharLiteralExpression exp) {
            return null;
        }

        @Override
        public Set<String> visit(CFloatLiteralExpression exp) {
            return null;
        }

        @Override
        public Set<String> visit(CImaginaryLiteralExpression exp) {
            return exp.getValue().accept(this);
        }

        @Override
        public Set<String> visit(CIntegerLiteralExpression exp) {
            this.values.add(exp.getValue());
            return null;
        }

        @Override
        public Set<String> visit(CStringLiteralExpression exp) {
            return null;
        }

        @Override
        public Set<String> visit(CTypeIdExpression exp) {
            return null;
        }

        @Override
        public Set<String> visit(CUnaryExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp);
            if (val == null) {
                return exp.getOperand().accept(this);
            }
            this.values.add(val);
            return null;
        }

        @Override
        public Set<String> visit(CPointerExpression exp) {
            BigInteger val = VariableClassificationBuilder.getNumber(exp);
            if (val == null) {
                return exp.getOperand().accept(this);
            }
            this.values.add(val);
            return null;
        }

        @Override
        public Set<String> visit(CAddressOfLabelExpression exp) {
            return null;
        }
    }
}

