/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.assumptions;

import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public enum PreventingHeuristic {
    PATHLENGTH("PL"),
    SUCCESSORCOMPTIME("SCT"),
    PATHCOMPTIME("PCT"),
    ASSUMEEDGESINPATH("AEIP"),
    ASSIGNMENTSINPATH("ASIP"),
    REPETITIONSINPATH("RIP"),
    MEMORYUSED("MU"),
    MEMORYOUT("MO"),
    TIMEOUT("TO"),
    LOOPITERATIONS("LI"),
    EDGECOUNT("EC");

    private final String predicateString;

    private PreventingHeuristic(String predicateStr) {
        this.predicateString = predicateStr;
    }

    public BooleanFormula getFormula(FormulaManagerView fmgr, long thresholdValue) {
        NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> nfmgr = fmgr.getRationalFormulaManager();
        NumeralFormula.RationalFormula number = (NumeralFormula.RationalFormula)nfmgr.makeNumber(thresholdValue);
        NumeralFormula.RationalFormula var = (NumeralFormula.RationalFormula)nfmgr.makeVariable(this.predicateString);
        return nfmgr.equal(var, number);
    }
}

