/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AutomatonGraphmlCommon {
    public static final String SINK_NODE_ID = "sink";
    public static final NodeType defaultNodeType = NodeType.ONPATH;

    public static boolean handleAsEpsilonEdge(CFAEdge edge) {
        if (AutomatonGraphmlCommon.handleAsEpsilonEdge0(edge)) {
            return edge.getSuccessor().getNumLeavingEdges() > 0;
        }
        return false;
    }

    private static boolean handleAsEpsilonEdge0(CFAEdge edge) {
        if (edge instanceof BlankEdge) {
            return true;
        }
        if (edge instanceof CFunctionReturnEdge) {
            return false;
        }
        if (edge instanceof CDeclarationEdge) {
            CDeclarationEdge declEdge = (CDeclarationEdge)edge;
            CDeclaration decl = declEdge.getDeclaration();
            if (decl instanceof CFunctionDeclaration) {
                return true;
            }
            if (decl instanceof CTypeDeclaration) {
                return true;
            }
            if (decl instanceof CVariableDeclaration) {
                CVariableDeclaration varDecl = (CVariableDeclaration)decl;
                return varDecl.getName().toUpperCase().startsWith("__CPACHECKER_TMP");
            }
        }
        return false;
    }

    public static class GraphMlBuilder {
        private final Document doc;
        private final Writer target;

        public GraphMlBuilder(Appendable target) throws ParserConfigurationException {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.target = CharStreams.asWriter((Appendable)target);
        }

        public Element createElement(GraphMlTag tag) {
            return this.doc.createElement(tag.toString());
        }

        public Element createDataElement(KeyDef key, String value) {
            Element result = this.createElement(GraphMlTag.DATA);
            result.setAttribute("key", key.id);
            result.setTextContent(value);
            return result;
        }

        public Element createEdgeElement(String from, String to) {
            Element result = this.createElement(GraphMlTag.EDGE);
            result.setAttribute("source", from);
            result.setAttribute("target", to);
            return result;
        }

        public Element createKeyDefElement(KeyDef keyDef, @Nullable String defaultValue) {
            return this.createKeyDefElement(keyDef.id, keyDef.keyFor, keyDef.attrName, keyDef.attrType, defaultValue);
        }

        public Element createKeyDefElement(String id, String keyFor, String attrName, String attrType, @Nullable String defaultValue) {
            Preconditions.checkNotNull((Object)this.doc);
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)keyFor);
            Preconditions.checkNotNull((Object)attrName);
            Preconditions.checkNotNull((Object)attrType);
            Element result = this.createElement(GraphMlTag.KEY);
            result.setAttribute("id", id);
            result.setAttribute("for", keyFor);
            result.setAttribute("attr.name", attrName);
            result.setAttribute("attr.type", attrType);
            if (defaultValue != null) {
                Element defaultValueElement = this.createElement(GraphMlTag.DEFAULT);
                defaultValueElement.setTextContent(defaultValue);
                result.appendChild(defaultValueElement);
            }
            return result;
        }

        public Element createNodeElement(String nodeId, NodeType nodeType) throws IOException {
            Element result = this.createElement(GraphMlTag.NODE);
            result.setAttribute("id", nodeId);
            if (nodeType != defaultNodeType) {
                this.addDataElementChild(result, KeyDef.NODETYPE, nodeType.toString());
            }
            return result;
        }

        public void appendNewNode(String nodeId, NodeType nodeType) throws IOException {
            Element result = this.createNodeElement(nodeId, nodeType);
            this.appendToAppendable(result);
        }

        public Element addDataElementChild(Element childOf, KeyDef key, String value) {
            Element result = this.createDataElement(key, value);
            childOf.appendChild(result);
            return result;
        }

        public void appendDataElement(KeyDef key, String value) {
            Element result = this.createDataElement(key, value);
            this.appendToAppendable(result);
        }

        public void appendDocHeader() throws IOException {
            this.target.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            this.target.append("<graphml xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://graphml.graphdrawing.org/xmlns\">\n");
        }

        public void appendGraphHeader(GraphType pGraphType, String pSourceLanguage) throws IOException {
            this.target.append("<graph edgedefault=\"directed\">");
            this.appendDataElement(KeyDef.SOURCECODELANGUAGE, pSourceLanguage);
        }

        public void appendNewKeyDef(KeyDef keyDef, @Nullable String defaultValue) {
            this.appendToAppendable(this.createKeyDefElement(keyDef, defaultValue));
        }

        public void appendToAppendable(Node n) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(n), new StreamResult(this.target));
            }
            catch (TransformerException ex) {
                throw new RuntimeException("Error while dumping program path", ex);
            }
        }

        public void appendFooter() throws IOException {
            this.target.append("</graph>\n");
            this.target.append("</graphml>\n");
        }
    }

    public static enum GraphMlTag {
        NODE("node"),
        DATA("data"),
        KEY("key"),
        GRAPH("graph"),
        DEFAULT("default"),
        EDGE("edge");

        public final String text;

        private GraphMlTag(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum NodeType {
        ANNOTATION("annotation"),
        ONPATH("path");

        public final String text;

        private NodeType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static NodeType fromString(String nodeTypeString) {
            return NodeType.valueOf(nodeTypeString.trim().toLowerCase());
        }
    }

    public static enum GraphType {
        PROGRAMPATH("traces automaton"),
        CONDITION("assumptions automaton");

        public final String text;

        private GraphType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum NodeFlag {
        ISFRONTIER(KeyDef.ISFRONTIERNODE),
        ISVIOLATION(KeyDef.ISVIOLATIONNODE),
        ISENTRY(KeyDef.ISENTRYNODE),
        ISSINKNODE(KeyDef.ISSINKNODE);

        public final KeyDef key;
        private static final Map<String, NodeFlag> stringToFlagMap;

        private NodeFlag(KeyDef key) {
            this.key = key;
        }

        public static NodeFlag getNodeFlagByKey(String key) {
            return stringToFlagMap.get(key);
        }

        static {
            stringToFlagMap = Maps.newHashMap();
            for (NodeFlag f : NodeFlag.values()) {
                stringToFlagMap.put(f.key.id, f);
            }
        }
    }

    public static enum KeyDef {
        INVARIANT("invariant", "node", "invariant", "string"),
        NAMED("named", "node", "namedValue", "string"),
        NODETYPE("nodetype", "node", "nodeType", "string"),
        ISFRONTIERNODE("frontier", "node", "isFrontierNode", "boolean"),
        ISVIOLATIONNODE("violation", "node", "isViolationNode", "boolean"),
        ISENTRYNODE("entry", "node", "isEntryNode", "boolean"),
        ISSINKNODE("sink", "node", "isSinkNode", "boolean"),
        SOURCECODELANGUAGE("sourcecodelang", "graph", "sourcecodeLanguage", "string"),
        SOURCECODE("sourcecode", "edge", "sourcecode", "string"),
        ORIGINLINE("originline", "edge", "lineNumberInOrigin", "int"),
        OFFSET("offset", "edge", "offset", "int"),
        ORIGINFILE("originfile", "edge", "originFileName", "string"),
        LINECOLS("lineCols", "edge", "lineColSet", "string"),
        NEGATIVECASE("negated", "edge", "negativeCase", "string"),
        ASSUMPTION("assumption", "edge", "assumption", "string"),
        FUNCTIONENTRY("enterFunction", "edge", "enterFunction", "string"),
        FUNCTIONEXIT("returnFrom", "edge", "returnFromFunction", "string"),
        CFAPREDECESSORNODE("predecessor", "edge", "predecessor", "string"),
        CFASUCCESSORNODE("successor", "edge", "successor", "string");

        public final String id;
        public final String keyFor;
        public final String attrName;
        public final String attrType;

        private KeyDef(String id, String keyFor, String attrName, String attrType) {
            this.id = id;
            this.keyFor = keyFor;
            this.attrName = attrName;
            this.attrType = attrType;
        }

        public String toString() {
            return this.id;
        }
    }
}

