/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NondeterministicFiniteAutomaton<T> {
    private State mInitialState;
    private HashSet<State> mFinalStates;
    private final ArrayList<Set<Edge>> mOutgoingEdges;
    private final ArrayList<Set<Edge>> mIncomingEdges;
    private final ArrayList<Edge> mEdges;
    private int mStatesCounter;
    private final StatePool.StateIterable mStateIterable = new StatePool.StateIterable(this);

    public NondeterministicFiniteAutomaton() {
        this.mFinalStates = new HashSet();
        this.mOutgoingEdges = new ArrayList();
        this.mIncomingEdges = new ArrayList();
        this.mEdges = new ArrayList();
        this.setInitialState(this.createState());
    }

    public State getInitialState() {
        return this.mInitialState;
    }

    public Set<State> getFinalStates() {
        return this.mFinalStates;
    }

    public void setInitialState(State pInitialState) {
        this.mInitialState = pInitialState;
    }

    public void setFinalStates(Set<State> pFinalStates) {
        this.mFinalStates.clear();
        this.mFinalStates.addAll(pFinalStates);
    }

    public void addToFinalStates(State pFinalStates) {
        this.mFinalStates.add(pFinalStates);
    }

    public boolean isFinalState(State pState) {
        return this.mFinalStates.contains(pState);
    }

    public Iterable<State> getStates() {
        return this.mStateIterable;
    }

    public State createState() {
        State lState = StatePool.STATE_POOL.get(this);
        this.mOutgoingEdges.add(new HashSet());
        this.mIncomingEdges.add(new HashSet());
        return lState;
    }

    public Edge createEdge(State pSource, State pTarget, T pLabel) {
        Edge lEdge = new Edge(pSource, pTarget, pLabel);
        this.addEdge(pSource, pTarget, lEdge);
        return lEdge;
    }

    private void addEdge(State pSource, State pTarget, Edge pEdge) {
        this.mOutgoingEdges.get(pSource.ID).add(pEdge);
        this.mIncomingEdges.get(pTarget.ID).add(pEdge);
        this.mEdges.add(pEdge);
    }

    public Iterable<Edge> getEdges() {
        return this.mEdges;
    }

    public Collection<Edge> getOutgoingEdges(State pState) {
        return this.mOutgoingEdges.get(pState.ID);
    }

    public Collection<Edge> getIncomingEdges(State pState) {
        return this.mIncomingEdges.get(pState.ID);
    }

    public NondeterministicFiniteAutomaton<T> getLambdaFreeAutomaton() {
        NondeterministicFiniteAutomaton lLambdaFreeAutomaton = new NondeterministicFiniteAutomaton();
        for (int lIndex = 0; lIndex < this.mStatesCounter - 1; ++lIndex) {
            lLambdaFreeAutomaton.createState();
        }
        Set<State> lFinalStates = this.getFinalStates();
        lLambdaFreeAutomaton.setFinalStates(this.getFinalStates());
        State lInitialState = this.getInitialState();
        for (State lState : this.getLambdaClosure(lInitialState)) {
            if (!lFinalStates.contains(lState)) continue;
            lLambdaFreeAutomaton.addToFinalStates(lInitialState);
        }
        for (State lState : this.getStates()) {
            for (State lClosureElement : this.getLambdaClosure(lState)) {
                for (Edge lOutgoingEdge : this.getOutgoingEdges(lClosureElement)) {
                    if (lOutgoingEdge.getLabel() == null) continue;
                    State lTarget = lOutgoingEdge.getTarget();
                    for (State lTargetClosureElement : this.getLambdaClosure(lTarget)) {
                        if (lOutgoingEdge.getSource().equals(lState) && lOutgoingEdge.getTarget().equals(lTargetClosureElement)) {
                            super.addEdge(lState, lTargetClosureElement, lOutgoingEdge);
                            continue;
                        }
                        lLambdaFreeAutomaton.createEdge(lState, lTargetClosureElement, lOutgoingEdge.getLabel());
                    }
                }
            }
        }
        return lLambdaFreeAutomaton;
    }

    private Set<State> getLambdaClosure(State pState) {
        HashSet<State> lClosure = new HashSet<State>();
        HashSet<State> lWorkset = new HashSet<State>();
        lWorkset.add(pState);
        while (!lWorkset.isEmpty()) {
            State lCurrentState = (State)lWorkset.iterator().next();
            lWorkset.remove(lCurrentState);
            if (lClosure.contains(lCurrentState)) continue;
            lClosure.add(lCurrentState);
            for (Edge lOutgoingEdge : this.getOutgoingEdges(lCurrentState)) {
                if (lOutgoingEdge.getLabel() != null) continue;
                State lTarget = lOutgoingEdge.getTarget();
                lWorkset.add(lTarget);
            }
        }
        return lClosure;
    }

    public String toString() {
        StringBuilder lBuffer = new StringBuilder();
        lBuffer.append("Initial State: " + this.getInitialState().ID + "\n");
        lBuffer.append("Final States: { ");
        boolean lFirst = true;
        for (State lFinalState : this.getFinalStates()) {
            if (lFirst) {
                lFirst = false;
            } else {
                lBuffer.append(", ");
            }
            lBuffer.append(lFinalState.ID);
        }
        lBuffer.append(" }\n");
        for (Edge lEdge : this.getEdges()) {
            Object lLabel = lEdge.getLabel();
            String lLabelString = lLabel != null ? lLabel.toString() : "Lambda";
            lBuffer.append(lEdge.getSource().ID + " -[" + lLabelString + "]> " + lEdge.getTarget().ID);
            lBuffer.append("\n");
        }
        return lBuffer.toString();
    }

    public class Edge {
        private State mSource;
        private State mTarget;
        private T mLabel;

        private Edge(State pSource, State pTarget, T pLabel) {
            this.mSource = pSource;
            this.mTarget = pTarget;
            this.mLabel = pLabel;
        }

        public State getSource() {
            return this.mSource;
        }

        public State getTarget() {
            return this.mTarget;
        }

        public T getLabel() {
            return this.mLabel;
        }

        public int hashCode() {
            return 31 * this.mSource.ID + this.mTarget.ID;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther == null) {
                return false;
            }
            if (!pOther.getClass().equals(this.getClass())) {
                return false;
            }
            Edge lEdge = (Edge)this.getClass().cast(pOther);
            if (lEdge.mSource.equals(this.mSource) && lEdge.mTarget.equals(this.mTarget)) {
                if (this.mLabel == null) {
                    return lEdge.mLabel == null;
                }
                return this.mLabel.equals(lEdge.mLabel);
            }
            return false;
        }
    }

    private static class StatePool {
        private static final StatePool STATE_POOL = new StatePool();
        private ArrayList<State> mPool = new ArrayList();
        private int mNextStateId = 0;

        private StatePool() {
        }

        public State get(NondeterministicFiniteAutomaton<?> pAutomaton) {
            State lState;
            if (((NondeterministicFiniteAutomaton)pAutomaton).mStatesCounter == this.mPool.size()) {
                lState = new State(this.mNextStateId++);
                this.mPool.add(lState);
            } else {
                lState = this.mPool.get(((NondeterministicFiniteAutomaton)pAutomaton).mStatesCounter);
            }
            ((NondeterministicFiniteAutomaton)pAutomaton).mStatesCounter++;
            return lState;
        }

        private static class StateSetIterator
        implements Iterator<State> {
            private final int mSize;
            private int mCounter;

            public StateSetIterator(int pSize) {
                this.mSize = pSize;
                this.mCounter = 0;
            }

            @Override
            public boolean hasNext() {
                return this.mCounter < this.mSize;
            }

            @Override
            public State next() {
                State lState = (State)STATE_POOL.mPool.get(this.mCounter);
                ++this.mCounter;
                return lState;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class StateIterable
        implements Iterable<State> {
            private final NondeterministicFiniteAutomaton<?> mAutomaton;

            public StateIterable(NondeterministicFiniteAutomaton<?> pAutomaton) {
                this.mAutomaton = pAutomaton;
            }

            @Override
            public Iterator<State> iterator() {
                return new StateSetIterator(((NondeterministicFiniteAutomaton)this.mAutomaton).mStatesCounter);
            }
        }
    }

    public static class State {
        public final int ID;

        private State(int pId) {
            this.ID = pId;
        }
    }
}

