/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;

public class TargetLocationProvider {
    private final ReachedSetFactory reachedSetFactory;
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logManager;
    private final Configuration config;
    private final CFA cfa;
    private static final String specificationPropertyName = "specification";

    public TargetLocationProvider(ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, LogManager pLogManager, Configuration pConfig, CFA pCfa) {
        this.reachedSetFactory = pReachedSetFactory;
        this.shutdownNotifier = pShutdownNotifier;
        this.logManager = pLogManager;
        this.config = pConfig;
        this.cfa = pCfa;
    }

    @Nullable
    public ImmutableSet<CFANode> tryGetAutomatonTargetLocations(CFANode pRootNode) {
        return this.tryGetAutomatonTargetLocations(pRootNode, true);
    }

    @Nullable
    public ImmutableSet<CFANode> tryGetAutomatonTargetLocations(CFANode pRootNode, boolean pSkipRecursion) {
        try {
            ConfigurationBuilder configurationBuilder = Configuration.builder();
            if (this.config.hasProperty(specificationPropertyName)) {
                configurationBuilder.copyOptionFrom(this.config, specificationPropertyName);
            }
            configurationBuilder.setOption("output.disable", "true");
            configurationBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.functionpointer.FunctionPointerCPA");
            configurationBuilder.setOption("cpa.callstack.skipRecursion", Boolean.toString(pSkipRecursion));
            Configuration configuration = configurationBuilder.build();
            CPABuilder cpaBuilder = new CPABuilder(configuration, this.logManager, this.shutdownNotifier, this.reachedSetFactory);
            ConfigurableProgramAnalysis cpa = cpaBuilder.buildCPAWithSpecAutomatas(this.cfa);
            ReachedSet reached = this.reachedSetFactory.create();
            reached.add(cpa.getInitialState(pRootNode, StateSpacePartition.getDefaultPartition()), cpa.getInitialPrecision(pRootNode, StateSpacePartition.getDefaultPartition()));
            CPAAlgorithm targetFindingAlgorithm = CPAAlgorithm.create(cpa, this.logManager, configuration, this.shutdownNotifier);
            HashSet result = new HashSet();
            boolean changed = true;
            while (changed) {
                targetFindingAlgorithm.run(reached);
                changed = result.addAll(FluentIterable.from((Iterable)reached).filter(AbstractStates.IS_TARGET_STATE).transform(AbstractStates.EXTRACT_LOCATION).toList());
            }
            CPAs.closeCpaIfPossible(cpa, this.logManager);
            CPAs.closeIfPossible(targetFindingAlgorithm, this.logManager);
            return ImmutableSet.copyOf(result);
        }
        catch (CPAException e) {
            if (!this.shutdownNotifier.shouldShutdown()) {
                if (pSkipRecursion || !pSkipRecursion && !e.toString().toLowerCase().contains("recursion")) {
                    this.logManager.logException(Level.WARNING, (Throwable)e, "Unable to find target locations. Defaulting to selecting all locations.");
                } else {
                    this.logManager.logException(Level.FINEST, (Throwable)e, "Recursion detected. Defaulting to selecting all locations.");
                }
            }
            return null;
        }
        catch (InterruptedException | InvalidConfigurationException e) {
            if (!this.shutdownNotifier.shouldShutdown()) {
                this.logManager.logException(Level.WARNING, e, "Unable to find target locations. Defaulting to selecting all locations.");
            }
            return null;
        }
    }
}

