/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.blocking.ReducedEdge;
import org.sosy_lab.cpachecker.util.blocking.ReducedFunction;
import org.sosy_lab.cpachecker.util.blocking.ReducedNode;
import org.sosy_lab.cpachecker.util.blocking.interfaces.BlockComputer;

@Options(prefix="blockreducer")
public class BlockedCFAReducer
implements BlockComputer {
    @Option(secure=true, description="Do at most n summarizations on a node.")
    private int reductionThreshold = 100;
    @Option(secure=true, description="Allow reduction of loop heads; calculate abstractions always at loop heads?")
    private boolean allowReduceLoopHeads = false;
    @Option(secure=true, description="Allow reduction of function entries; calculate abstractions always at function entries?")
    private boolean allowReduceFunctionEntries = true;
    @Option(secure=true, description="Allow reduction of function exits; calculate abstractions always at function exits?")
    private boolean allowReduceFunctionExits = true;
    @Option(secure=true, name="reducedCfaFile", description="write the reduced cfa to the specified file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reducedCfaFile = Paths.get((String)"ReducedCfa.rsf", (String[])new String[0]);
    private int functionCallSeq = 0;
    private final Deque<FunctionEntryNode> inliningStack;
    private final LogManager logger;

    public BlockedCFAReducer(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.inliningStack = new ArrayDeque<FunctionEntryNode>();
    }

    private boolean isAbstractionNode(ReducedNode pNode) {
        return pNode.isLoopHead() && !this.allowReduceLoopHeads || pNode.isFunctionEntry() && !this.allowReduceFunctionEntries || pNode.isFunctionExit() && !this.allowReduceFunctionExits;
    }

    private void incSummarizationsOnNode(ReducedNode pNode, int pIncBy) {
        assert (this.reductionThreshold > 0);
        pNode.incSummarizations(pIncBy);
    }

    private int getSummarizationsOnNode(ReducedNode pNode) {
        return pNode.getSummarizations();
    }

    @VisibleForTesting
    boolean applySequenceRule(ReducedFunction pApplyTo) {
        boolean result = false;
        ArrayDeque<ReducedNode> toTraverse = new ArrayDeque<ReducedNode>();
        HashSet<ReducedEdge> traverseDone = new HashSet<ReducedEdge>();
        toTraverse.add(pApplyTo.getEntryNode());
        while (toTraverse.size() > 0) {
            ReducedNode u = (ReducedNode)toTraverse.remove();
            for (ReducedEdge e : pApplyTo.getLeavingEdges(u)) {
                List<ReducedEdge> vLeavingEdges;
                ReducedNode v = e.getPointsTo();
                if (!traverseDone.add(e) || u == v || (vLeavingEdges = pApplyTo.getLeavingEdges(v)).isEmpty()) continue;
                if (this.getSummarizationsOnNode(u) + vLeavingEdges.size() > this.reductionThreshold) {
                    toTraverse.add(v);
                    continue;
                }
                if (pApplyTo.getNumEnteringEdges(v) != 1) {
                    toTraverse.add(v);
                    continue;
                }
                if (this.isAbstractionNode(v)) {
                    toTraverse.add(v);
                    continue;
                }
                boolean uvRemoved = false;
                for (ReducedEdge f : vLeavingEdges) {
                    ReducedNode w = f.getPointsTo();
                    assert (u != v);
                    assert (v != w);
                    ReducedEdge sumEdge = new ReducedEdge(w);
                    sumEdge.addEdge(e);
                    sumEdge.addEdge(f);
                    pApplyTo.removeEdge(v, w, f);
                    if (!uvRemoved) {
                        pApplyTo.removeEdge(u, v, e);
                        this.incSummarizationsOnNode(u, v.getSummarizations());
                        uvRemoved = true;
                    }
                    pApplyTo.addEdge(u, w, sumEdge);
                    this.incSummarizationsOnNode(u, 1);
                }
                toTraverse.clear();
                traverseDone.clear();
                toTraverse.add(u);
                result = true;
            }
        }
        return result;
    }

    @VisibleForTesting
    boolean applyChoiceRule(ReducedFunction pApplyTo) {
        boolean result = false;
        ArrayDeque<ReducedNode> toTraverse = new ArrayDeque<ReducedNode>();
        HashSet<ReducedNode> traverseDone = new HashSet<ReducedNode>();
        toTraverse.add(pApplyTo.getEntryNode());
        while (toTraverse.size() > 0) {
            ReducedNode u = (ReducedNode)toTraverse.removeFirst();
            if (traverseDone.contains(u)) continue;
            List<ReducedEdge> leavingEdges = pApplyTo.getLeavingEdges(u);
            if (leavingEdges.size() < 2 || this.getSummarizationsOnNode(u) >= this.reductionThreshold) {
                for (ReducedEdge e : leavingEdges) {
                    toTraverse.add(e.getPointsTo());
                }
                traverseDone.add(u);
                continue;
            }
            boolean onePairMerged = false;
            for (int x = 0; x < leavingEdges.size() && !onePairMerged; ++x) {
                for (int y = x + 1; y < leavingEdges.size() && !onePairMerged; ++y) {
                    ReducedNode v2;
                    ReducedEdge edgeX = leavingEdges.get(x);
                    ReducedEdge edgeY = leavingEdges.get(y);
                    ReducedNode v1 = edgeX.getPointsTo();
                    if (v1 == (v2 = edgeY.getPointsTo())) {
                        ReducedEdge sumEdge = new ReducedEdge(v1);
                        sumEdge.addEdge(edgeX);
                        sumEdge.addEdge(edgeY);
                        pApplyTo.removeEdge(u, v1, edgeX);
                        pApplyTo.removeEdge(u, v2, edgeY);
                        pApplyTo.addEdge(u, v1, sumEdge);
                        this.incSummarizationsOnNode(u, 1);
                        onePairMerged = true;
                        continue;
                    }
                    toTraverse.add(v1);
                    toTraverse.add(v2);
                }
            }
            if (onePairMerged) {
                toTraverse.clear();
                traverseDone.clear();
                toTraverse.add(u);
                result = true;
                continue;
            }
            traverseDone.add(u);
        }
        return result;
    }

    private ReducedFunction inlineAndSummarize(FunctionEntryNode pFunctionNode, CFA cfa) {
        ++this.functionCallSeq;
        this.inliningStack.push(pFunctionNode);
        HashSet<CFAEdge> traversed = new HashSet<CFAEdge>();
        ArrayDeque<ReducedNode> openEndpoints = new ArrayDeque<ReducedNode>();
        FunctionNodeManager functionNodes = new FunctionNodeManager(this.functionCallSeq, cfa);
        ReducedNode entryNode = functionNodes.getWrapper(pFunctionNode);
        ReducedNode exitNode = functionNodes.getWrapper(pFunctionNode.getExitNode());
        ReducedFunction result = new ReducedFunction(entryNode, exitNode);
        openEndpoints.add(result.getEntryNode());
        while (openEndpoints.size() > 0) {
            ReducedNode uSn = (ReducedNode)openEndpoints.removeFirst();
            for (CFAEdge e : CFAUtils.leavingEdges(uSn.getWrapped())) {
                if (!traversed.add(e)) continue;
                if (e instanceof CFunctionCallEdge) {
                    CFunctionCallEdge callEdge = (CFunctionCallEdge)e;
                    ReducedNode callReturnTarget = functionNodes.getWrapper(callEdge.getSummaryEdge().getSuccessor());
                    CFunctionEntryNode calledFunction = callEdge.getSuccessor();
                    if (this.inliningStack.contains(calledFunction)) {
                        result.addEdge(uSn, callReturnTarget);
                    } else {
                        ReducedFunction functionSum = this.inlineAndSummarize(calledFunction, cfa);
                        result.insertFunctionSum(functionSum);
                        result.addEdge(uSn, functionSum.getEntryNode());
                        if (functionSum.getExitNode().getWrapped().getNumEnteringEdges() > 0) {
                            result.addEdge(functionSum.getExitNode(), callReturnTarget);
                        }
                    }
                    openEndpoints.add(callReturnTarget);
                    continue;
                }
                if (e.getSuccessor() == pFunctionNode.getExitNode()) {
                    result.addEdge(uSn, exitNode);
                    continue;
                }
                ReducedNode vSn = functionNodes.getWrapper(e.getSuccessor());
                result.addEdge(uSn, vSn);
                openEndpoints.add(vSn);
            }
        }
        this.applyReductionSequences(result);
        this.inliningStack.pop();
        return result;
    }

    @VisibleForTesting
    void applyReductionSequences(ReducedFunction pApplyTo) {
        boolean choiceApplied;
        boolean sequenceApplied;
        do {
            sequenceApplied = this.applySequenceRule(pApplyTo);
            choiceApplied = this.applyChoiceRule(pApplyTo);
        } while (sequenceApplied || choiceApplied);
    }

    private String getRsfEntryFor(ReducedNode pNode) {
        return String.format("%s_%s_%d_%d", pNode.getWrapped().getFunctionName(), pNode.getNodeKindText(), pNode.getFunctionCallId(), pNode.getWrapped().getNodeNumber());
    }

    @VisibleForTesting
    void printInlinedCfa(Map<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> pInlinedCfa, Writer pOut) throws IOException {
        for (Map.Entry<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> outerEntry : pInlinedCfa.entrySet()) {
            ReducedNode u = outerEntry.getKey();
            Map<ReducedNode, Set<ReducedEdge>> uTarget = outerEntry.getValue();
            for (Map.Entry<ReducedNode, Set<ReducedEdge>> entry : uTarget.entrySet()) {
                ReducedNode v = entry.getKey();
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    pOut.append("REL\t").append(this.getRsfEntryFor(u)).append('\t').append(this.getRsfEntryFor(v)).append(System.lineSeparator());
                }
            }
        }
    }

    @Override
    public ImmutableSet<CFANode> computeAbstractionNodes(CFA pCfa) {
        assert (pCfa != null);
        assert (this.inliningStack.size() == 0);
        assert (this.functionCallSeq == 0);
        this.functionCallSeq = 0;
        ReducedFunction reducedProgram = this.inlineAndSummarize(pCfa.getMainFunction(), pCfa);
        if (this.reducedCfaFile != null) {
            Map<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> inlinedCfa = reducedProgram.getInlinedCfa();
            try (Writer w = Files.openOutputFile((Path)this.reducedCfaFile, (FileWriteMode[])new FileWriteMode[0]);){
                this.printInlinedCfa(inlinedCfa, w);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write the reduced CFA to file");
            }
        }
        Set<ReducedNode> abstractionNodes = reducedProgram.getAllActiveNodes();
        HashSet result = Sets.newHashSetWithExpectedSize((int)abstractionNodes.size());
        for (ReducedNode n : abstractionNodes) {
            result.add(n.getWrapped());
        }
        return ImmutableSet.copyOf((Collection)result);
    }

    private static class FunctionNodeManager {
        private final CFA cfa;
        private final Map<CFANode, ReducedNode> nodeMapping = new HashMap<CFANode, ReducedNode>();
        private int functionCallId;

        public ReducedNode getWrapper(CFANode pNode) {
            ReducedNode result = this.nodeMapping.get(pNode);
            if (result == null) {
                boolean isLoopHead = ((ImmutableSet)this.cfa.getAllLoopHeads().get()).contains((Object)pNode);
                result = new ReducedNode(pNode, isLoopHead);
                result.setFunctionCallId(this.functionCallId);
                this.nodeMapping.put(pNode, result);
            }
            return result;
        }

        public FunctionNodeManager(int pFunctionCallId, CFA pCfa) {
            this.functionCallId = pFunctionCallId;
            this.cfa = pCfa;
        }
    }
}

