/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.blocking.ReducedEdge;
import org.sosy_lab.cpachecker.util.blocking.ReducedNode;

class ReducedFunction {
    private final Table<ReducedNode, ReducedNode, Set<ReducedEdge>> cfaEdges;
    private final Multiset<ReducedNode> activeNodes;
    private final ReducedNode entryNode;
    private final ReducedNode exitNode;

    public ReducedFunction(ReducedNode pEntryNode, ReducedNode pExitNode) {
        assert (pEntryNode != null);
        assert (pExitNode != null);
        this.cfaEdges = HashBasedTable.create();
        this.activeNodes = HashMultiset.create();
        this.entryNode = pEntryNode;
        this.exitNode = pExitNode;
    }

    public ReducedEdge addEdge(ReducedNode pFrom, ReducedNode pTo) {
        ReducedEdge edge = new ReducedEdge(pTo);
        this.addEdge(pFrom, pTo, edge);
        return edge;
    }

    public void addEdge(ReducedNode pFrom, ReducedNode pTo, ReducedEdge pEdge) {
        HashSet<ReducedEdge> edges = (HashSet<ReducedEdge>)this.cfaEdges.get((Object)pFrom, (Object)pTo);
        if (edges == null) {
            edges = new HashSet<ReducedEdge>();
        }
        edges.add(pEdge);
        this.cfaEdges.put((Object)pFrom, (Object)pTo, edges);
        this.activeNodes.add((Object)pFrom);
        this.activeNodes.add((Object)pTo);
        assert (this.activeNodes.count((Object)pFrom) > 0);
        assert (this.activeNodes.count((Object)pTo) > 0);
    }

    public void removeEdge(ReducedNode pFrom, ReducedNode pTo, ReducedEdge pEdge) {
        assert (this.cfaEdges.contains((Object)pFrom, (Object)pTo));
        assert (this.activeNodes.count((Object)pFrom) > 0);
        assert (this.activeNodes.count((Object)pTo) > 0);
        assert (pEdge.getPointsTo() == pTo);
        Set edges = (Set)this.cfaEdges.get((Object)pFrom, (Object)pTo);
        if (edges != null) {
            edges.remove(pEdge);
            if (edges.size() == 0) {
                this.cfaEdges.remove((Object)pFrom, (Object)pTo);
            }
        }
        this.activeNodes.remove((Object)pFrom);
        this.activeNodes.remove((Object)pTo);
    }

    public void insertFunctionSum(ReducedFunction pToInline) {
        this.cfaEdges.putAll(pToInline.cfaEdges);
        this.activeNodes.addAll(pToInline.activeNodes);
    }

    public ReducedNode getEntryNode() {
        return this.entryNode;
    }

    public ReducedNode getExitNode() {
        return this.exitNode;
    }

    public Map<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> getInlinedCfa() {
        return this.cfaEdges.rowMap();
    }

    public List<ReducedEdge> getLeavingEdges(ReducedNode pOfNode) {
        ArrayList<ReducedEdge> result = new ArrayList<ReducedEdge>();
        Collection edges = this.cfaEdges.row((Object)pOfNode).values();
        for (Set edgesToNode : edges) {
            for (ReducedEdge e : edgesToNode) {
                result.add(e);
            }
        }
        return result;
    }

    public int getNumEnteringEdges(ReducedNode pOfNode) {
        int result = 0;
        Collection edges = this.cfaEdges.column((Object)pOfNode).values();
        for (Set edgesToNode : edges) {
            result += edgesToNode.size();
        }
        return result;
    }

    public int getNumLeavingEdges(ReducedNode pOfNode) {
        int result = 0;
        Collection edges = this.cfaEdges.row((Object)pOfNode).values();
        for (Set edgesToNode : edges) {
            result += edgesToNode.size();
        }
        return result;
    }

    public int getNumOfActiveNodes() {
        return this.activeNodes.elementSet().size();
    }

    public Set<ReducedNode> getAllActiveNodes() {
        return this.activeNodes.elementSet();
    }
}

