/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;

class ReducedNode {
    private static int uniqueNodeIdSequence = 0;
    private final CFANode wrappedNode;
    private final int uniqueNodeId;
    private int summarizations;
    private int functionCallId;
    private final boolean isLoopHead;

    public ReducedNode(CFANode pWrappedNode) {
        this(pWrappedNode, false);
    }

    public ReducedNode(CFANode pWrappedNode, boolean pIsLoopHead) {
        this.wrappedNode = pWrappedNode;
        this.uniqueNodeId = uniqueNodeIdSequence++;
        this.summarizations = 0;
        this.functionCallId = 0;
        this.isLoopHead = pIsLoopHead;
    }

    public CFANode getWrapped() {
        return this.wrappedNode;
    }

    public int getUniqueNodeId() {
        return this.uniqueNodeId;
    }

    public int getSummarizations() {
        return this.summarizations;
    }

    public void incSummarizations(int pIncBy) {
        this.summarizations += pIncBy;
    }

    public boolean isFunctionEntry() {
        return this.getWrapped() instanceof FunctionEntryNode;
    }

    public boolean isFunctionExit() {
        return this.getWrapped() instanceof FunctionExitNode;
    }

    public boolean isLoopHead() {
        return this.isLoopHead;
    }

    public String getNodeKindText() {
        if (this.isLoopHead()) {
            return "LoopHead";
        }
        if (this.isFunctionEntry()) {
            return "FunctEntry";
        }
        if (this.isFunctionExit()) {
            return "FunctExit";
        }
        return "Generic";
    }

    public void setFunctionCallId(int pCallId) {
        this.functionCallId = pCallId;
    }

    public int getFunctionCallId() {
        return this.functionCallId;
    }
}

