/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParsingFailedException;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class AppliedCustomInstructionParser {
    private final ShutdownNotifier notifier;

    public AppliedCustomInstructionParser(ShutdownNotifier pShN) {
        this.notifier = pShN;
    }

    public ImmutableMap<CFANode, AppliedCustomInstruction> parse(Path file) throws IOException, AppliedCustomInstructionParsingFailedException, InterruptedException {
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        CFAInfo cfaInfo = (CFAInfo)GlobalInfo.getInstance().getCFAInfo().get();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.toFile()), "UTF-8"));){
            String line = "";
            while (br.ready()) {
                ImmutableSet<CFANode> secNodes;
                this.notifier.shutdownIfNecessary();
                line = br.readLine();
                if (line == null) {
                    break;
                }
                String firstLine = line.trim();
                line = br.readLine();
                if (line == null) {
                    throw new AppliedCustomInstructionParsingFailedException("Wrong format, specification of end nodes not found. Expect that a custom instruction is specified in two lines. First line contains the start node and second line the end nodes.");
                }
                String[] secLine = line.trim().split("(\\w)+");
                CFANode firstNode = this.getCFANode(firstLine, cfaInfo);
                if (!this.sanityCheckCIApplication(firstNode, (Set<CFANode>)(secNodes = this.getCFANodes(secLine, cfaInfo)))) continue;
                map.put((Object)firstNode, (Object)new AppliedCustomInstruction(firstNode, (Collection<CFANode>)secNodes));
            }
        }
        return map.build();
    }

    public CFANode getCFANode(String pNodeID, CFAInfo cfaInfo) throws AppliedCustomInstructionParsingFailedException {
        try {
            return cfaInfo.getNodeByNodeNumber(Integer.parseInt(pNodeID));
        }
        catch (NumberFormatException ex) {
            throw new AppliedCustomInstructionParsingFailedException("It is not possible to parse " + pNodeID + " to an integer!", ex);
        }
    }

    public ImmutableSet<CFANode> getCFANodes(String[] pNodes, CFAInfo cfaInfo) throws AppliedCustomInstructionParsingFailedException {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (int i = 0; i < pNodes.length; ++i) {
            builder.add((Object)this.getCFANode(pNodes[i], cfaInfo));
        }
        return builder.build();
    }

    private boolean sanityCheckCIApplication(CFANode pNode, Set<CFANode> pSet) throws AppliedCustomInstructionParsingFailedException, InterruptedException {
        HashSet<CFANode> endNodes = new HashSet<CFANode>();
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> queue = new ArrayDeque<CFANode>();
        queue.add(pNode);
        visitedNodes.add(pNode);
        while (!queue.isEmpty()) {
            this.notifier.shutdownIfNecessary();
            CFANode pred = (CFANode)queue.poll();
            if (pSet.contains(pred)) {
                endNodes.add(pred);
                continue;
            }
            for (CFANode succ : CFAUtils.successorsOf(pred)) {
                if (visitedNodes.contains(succ)) continue;
                queue.add(succ);
                visitedNodes.add(succ);
            }
        }
        return pSet.equals(endNodes);
    }
}

