/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;

public class CustomInstructionApplications {
    private final Map<CFANode, AppliedCustomInstruction> cis;

    public CustomInstructionApplications(Map<CFANode, AppliedCustomInstruction> pCis) {
        this.cis = pCis;
    }

    public boolean isStartState(AbstractState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The state " + pState + " has to contain a location state!");
        }
        return this.cis.containsKey(locState);
    }

    public boolean isEndState(AbstractState pIsEnd, AbstractState pCIStart) throws CPAException {
        return this.isEndState(pIsEnd, AbstractStates.extractLocation(pCIStart));
    }

    public boolean isEndState(AbstractState pIsEnd, CFANode pCIStart) throws CPAException {
        assert (this.cis.containsKey(pCIStart));
        return this.cis.get(pCIStart).isEndState(pIsEnd);
    }

    public AppliedCustomInstruction getAppliedCustomInstructionFor(ARGState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The state " + pState + " has to contain a location state!");
        }
        if (!this.isStartState(pState)) {
            throw new CPAException("The state does not represent start of known custom instruction");
        }
        return this.cis.get(locState);
    }
}

