/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.coverage.CoveragePrinter;
import org.sosy_lab.cpachecker.util.coverage.CoveragePrinterGcov;

public class CoverageInformation {
    public static void writeCoverageInfo(Path outputFile, ReachedSet reached, CFA cfa, LogManager logger) {
        Set<CFANode> reachedLocations = CoverageInformation.getAllLocationsFromReached(reached);
        HashMap<String, CoveragePrinter> printers = new HashMap<String, CoveragePrinter>();
        for (CFANode node : cfa.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                boolean visited;
                boolean bl = visited = reachedLocations.contains(edge.getPredecessor()) && reachedLocations.contains(edge.getSuccessor());
                if (edge instanceof MultiEdge) {
                    for (CFAEdge innerEdge : ((MultiEdge)edge).getEdges()) {
                        CoverageInformation.handleEdgeCoverage(innerEdge, visited, printers);
                    }
                    continue;
                }
                CoverageInformation.handleEdgeCoverage(edge, visited, printers);
            }
        }
        for (FunctionEntryNode entryNode : cfa.getAllFunctionHeads()) {
            FileLocation loc = entryNode.getFileLocation();
            if (loc.getStartingLineNumber() == 0) continue;
            String functionName = entryNode.getFunctionName();
            CoveragePrinter printer = CoverageInformation.getPrinter(loc, printers);
            int startingLine = loc.getStartingLineInOrigin();
            int endingLine = loc.getEndingLineNumber() - loc.getStartingLineNumber() + loc.getStartingLineInOrigin();
            printer.addExistingFunction(functionName, startingLine, endingLine);
            if (!reachedLocations.contains(entryNode)) continue;
            printer.addVisitedFunction(functionName);
        }
        try (Writer out = Files.openOutputFile((Path)outputFile, (FileWriteMode[])new FileWriteMode[0]);){
            for (Map.Entry entry : printers.entrySet()) {
                ((CoveragePrinter)entry.getValue()).print(out, (String)entry.getKey());
            }
        }
        catch (IOException e) {
            logger.logUserException(Level.WARNING, (Throwable)e, "Could not write coverage information to file");
        }
    }

    private static void handleEdgeCoverage(CFAEdge edge, boolean visited, Map<String, CoveragePrinter> printers) {
        int line;
        FileLocation loc = edge.getFileLocation();
        if (loc.getStartingLineNumber() == 0) {
            return;
        }
        if (edge instanceof ADeclarationEdge && ((ADeclarationEdge)edge).getDeclaration() instanceof AFunctionDeclaration) {
            return;
        }
        CoveragePrinter printer = CoverageInformation.getPrinter(loc, printers);
        int startingLine = loc.getStartingLineInOrigin();
        int endingLine = loc.getEndingLineNumber() - loc.getStartingLineNumber() + loc.getStartingLineInOrigin();
        for (line = startingLine; line <= endingLine; ++line) {
            printer.addExistingLine(line);
        }
        if (visited) {
            for (line = startingLine; line <= endingLine; ++line) {
                printer.addVisitedLine(line);
            }
        }
    }

    private static CoveragePrinter getPrinter(FileLocation loc, Map<String, CoveragePrinter> printers) {
        assert (loc.getStartingLineNumber() != 0);
        String file = loc.getFileName();
        CoveragePrinter printer = printers.get(file);
        if (printer == null) {
            printer = new CoveragePrinterGcov();
            printers.put(file, printer);
        }
        return printer;
    }

    private static Set<CFANode> getAllLocationsFromReached(ReachedSet reached) {
        if (reached instanceof ForwardingReachedSet) {
            reached = ((ForwardingReachedSet)reached).getDelegate();
        }
        if (reached instanceof LocationMappedReachedSet) {
            return ((LocationMappedReachedSet)reached).getLocations();
        }
        return FluentIterable.from((Iterable)reached).transform(AbstractStates.EXTRACT_LOCATION).filter(Predicates.notNull()).toSet();
    }
}

