/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.util.coverage.CoveragePrinter;

class CoveragePrinterGcov
implements CoveragePrinter {
    private final BitSet visitedLines = new BitSet();
    private final Set<Integer> allLines = new HashSet<Integer>();
    private final Set<String> visitedFunctions = new HashSet<String>();
    private final Set<FunctionInfo> allFunctions = new HashSet<FunctionInfo>();
    private static final String TEXTNAME = "TN:";
    private static final String SOURCEFILE = "SF:";
    private static final String FUNCTION = "FN:";
    private static final String FUNCTIONDATA = "FNDA:";
    private static final String LINEDATA = "DA:";

    CoveragePrinterGcov() {
    }

    @Override
    public void addVisitedFunction(String pName) {
        this.visitedFunctions.add(pName);
    }

    @Override
    public void addExistingFunction(String pName, int pFirstLine, int pLastLine) {
        this.allFunctions.add(new FunctionInfo(pName, pFirstLine, pLastLine));
    }

    @Override
    public void addVisitedLine(int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        this.visitedLines.set(pLine);
    }

    @Override
    public void addExistingLine(int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        this.allLines.add(pLine);
    }

    @Override
    public void print(Appendable out, String originFile) throws IOException {
        out.append("TN:\n");
        out.append(SOURCEFILE + Paths.get((String)originFile, (String[])new String[0]).getAbsolutePath() + "\n");
        for (FunctionInfo info : this.allFunctions) {
            out.append(FUNCTION + info.firstLine + "," + info.name + "\n");
            out.append("#FN:" + info.lastLine + "\n");
        }
        for (String name : this.visitedFunctions) {
            out.append("FNDA:1," + name + "\n");
        }
        for (Integer line : this.allLines) {
            out.append(LINEDATA + line + "," + (this.visitedLines.get(line) ? 1 : 0) + "\n");
        }
        out.append("end_of_record\n");
    }

    private static class FunctionInfo {
        private final String name;
        private final int firstLine;
        private final int lastLine;

        FunctionInfo(String pName, int pFirstLine, int pLastLine) {
            this.name = pName;
            this.firstLine = pFirstLine;
            this.lastLine = pLastLine;
        }
    }
}

