/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

class MergeNode {
    private final int stateId;
    private final Map<Integer, Pair<Boolean, Boolean>> branchesMap;
    private final List<FunctionBody> incomingState;

    public MergeNode(int pElementId) {
        this.stateId = pElementId;
        this.branchesMap = new HashMap<Integer, Pair<Boolean, Boolean>>();
        this.incomingState = new ArrayList<FunctionBody>();
    }

    public int addBranch(FunctionBody currentFunction) {
        this.incomingState.add(currentFunction);
        HashSet<Integer> processedConditions = new HashSet<Integer>();
        for (BasicBlock elementInStack : currentFunction) {
            int idOfElementInStack = elementInStack.getStateId();
            boolean nextConditionValue = elementInStack.isCondition();
            boolean isClosedBefore = elementInStack.isClosedBefore();
            if (this.branchesMap.containsKey(idOfElementInStack)) {
                Pair<Boolean, Boolean> conditionPair = this.branchesMap.get(idOfElementInStack);
                boolean firstConditionValue = (Boolean)conditionPair.getFirst();
                boolean secondConditionValue = (Boolean)conditionPair.getSecond();
                if (!isClosedBefore && !secondConditionValue && !(firstConditionValue ^ nextConditionValue)) continue;
                processedConditions.add(idOfElementInStack);
                continue;
            }
            this.branchesMap.put(idOfElementInStack, (Pair<Boolean, Boolean>)Pair.of((Object)nextConditionValue, (Object)isClosedBefore));
        }
        this.setProcessedStates(processedConditions);
        return this.incomingState.size();
    }

    private void setProcessedStates(Set<Integer> pProcessedConditions) {
        for (FunctionBody stack : this.incomingState) {
            for (BasicBlock elem : stack) {
                if (!pProcessedConditions.contains(elem.getStateId())) continue;
                elem.setClosedBefore(true);
            }
        }
    }

    public List<FunctionBody> getIncomingStates() {
        return this.incomingState;
    }

    public String toString() {
        return "id: " + this.stateId + " >> " + this.branchesMap;
    }
}

