/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.Edge;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;
import org.sosy_lab.cpachecker.util.cwriter.MergeNode;

public class PathToCTranslator {
    private static Function<CAstNode, String> RAW_SIGNATURE_FUNCTION = new Function<CAstNode, String>(){

        public String apply(CAstNode pArg0) {
            return pArg0.toASTString();
        }
    };
    private final List<String> mGlobalDefinitionsList = new ArrayList<String>();
    private final List<String> mFunctionDecls = new ArrayList<String>();
    private int mFunctionIndex = 0;
    private final List<FunctionBody> mFunctionBodies = new ArrayList<FunctionBody>();

    private PathToCTranslator() {
        this.mGlobalDefinitionsList.add("extern void __VERIFIER_assume(int);");
        this.mGlobalDefinitionsList.add("extern void __VERIFIER_error();");
    }

    public static Appender translatePaths(ARGState argRoot, Set<ARGState> elementsOnErrorPath) {
        PathToCTranslator translator = new PathToCTranslator();
        translator.translatePaths0(argRoot, elementsOnErrorPath);
        return translator.generateCCode();
    }

    public static Appender translateSinglePath(ARGPath pPath) {
        PathToCTranslator translator = new PathToCTranslator();
        translator.translateSinglePath0(pPath);
        return translator.generateCCode();
    }

    private Appender generateCCode() {
        return Appenders.forIterable((Joiner)Joiner.on((char)'\n'), (Iterable)Iterables.concat(this.mGlobalDefinitionsList, this.mFunctionDecls, this.mFunctionBodies));
    }

    private void translatePaths0(ARGState firstElement, Set<ARGState> elementsOnPath) {
        ArrayList<Edge> waitlist = new ArrayList<Edge>();
        HashMap<Integer, MergeNode> mergeNodes = new HashMap<Integer, MergeNode>();
        Stack<FunctionBody> newStack = new Stack<FunctionBody>();
        this.startFunction(firstElement, newStack);
        waitlist.addAll(this.getRelevantChildrenOfState(firstElement, newStack, elementsOnPath));
        while (!waitlist.isEmpty()) {
            Collections.sort(waitlist);
            Edge nextEdge = (Edge)waitlist.remove(0);
            waitlist.addAll(this.handleEdge(nextEdge, mergeNodes, elementsOnPath));
        }
    }

    private String startFunction(ARGState firstFunctionElement, Stack<FunctionBody> functionStack) {
        CFunctionEntryNode functionStartNode = (CFunctionEntryNode)AbstractStates.extractLocation(firstFunctionElement);
        String freshFunctionName = this.getFreshFunctionName(functionStartNode);
        String lFunctionHeader = functionStartNode.getFunctionDefinition().getType().toASTString(freshFunctionName);
        FunctionBody newFunction = new FunctionBody(firstFunctionElement.getStateId(), lFunctionHeader);
        this.mFunctionDecls.add(lFunctionHeader + ";");
        this.mFunctionBodies.add(newFunction);
        functionStack.push(newFunction);
        return freshFunctionName;
    }

    private void translateSinglePath0(ARGPath pPath) {
        assert (pPath.size() >= 1);
        ARGPath.PathIterator pathIt = pPath.pathIterator();
        ARGState firstElement = pathIt.getAbstractState();
        Stack<FunctionBody> functionStack = new Stack<FunctionBody>();
        this.startFunction(firstElement, functionStack);
        while (pathIt.hasNext()) {
            pathIt.advance();
            CFAEdge currentCFAEdge = pathIt.getIncomingEdge();
            ARGState childElement = pathIt.getAbstractState();
            this.processEdge(childElement, currentCFAEdge, functionStack);
        }
    }

    private Collection<Edge> handleEdge(Edge nextEdge, Map<Integer, MergeNode> mergeNodes, Set<ARGState> elementsOnPath) {
        ARGState childElement = nextEdge.getChildState();
        CFAEdge edge = nextEdge.getEdge();
        Stack<FunctionBody> functionStack = nextEdge.getStack();
        functionStack = this.cloneStack(functionStack);
        this.processEdge(childElement, edge, functionStack);
        int noOfParents = FluentIterable.from(childElement.getParents()).filter(Predicates.in(elementsOnPath)).size();
        assert (noOfParents >= 1);
        if (noOfParents > 1) {
            int noOfProcessedBranches;
            assert (!(edge instanceof CFunctionCallEdge) && !childElement.isTarget());
            int elemId = childElement.getStateId();
            FunctionBody currentFunction = functionStack.peek();
            currentFunction.write("goto label_" + elemId + ";");
            MergeNode mergeNode = mergeNodes.get(elemId);
            if (mergeNode == null) {
                mergeNode = new MergeNode(elemId);
                mergeNodes.put(elemId, mergeNode);
            }
            if (noOfParents == (noOfProcessedBranches = mergeNode.addBranch(currentFunction))) {
                List<FunctionBody> incomingStacks = mergeNode.getIncomingStates();
                FunctionBody newFunction = PathToCTranslator.processIncomingStacks(incomingStacks);
                functionStack.pop();
                functionStack.push(newFunction);
                newFunction.write("label_" + elemId + ": ;");
            } else {
                return Collections.emptySet();
            }
        }
        return this.getRelevantChildrenOfState(childElement, functionStack, elementsOnPath);
    }

    private Collection<Edge> getRelevantChildrenOfState(ARGState currentElement, Stack<FunctionBody> functionStack, Set<ARGState> elementsOnPath) {
        ImmutableList relevantChildrenOfElement = FluentIterable.from(currentElement.getChildren()).filter(Predicates.in(elementsOnPath)).toList();
        if (relevantChildrenOfElement.size() == 1) {
            ARGState elem = (ARGState)Iterables.getOnlyElement((Iterable)relevantChildrenOfElement);
            CFAEdge e = currentElement.getEdgeToChild(elem);
            Edge newEdge = new Edge(elem, e, functionStack);
            return Collections.singleton(newEdge);
        }
        if (relevantChildrenOfElement.size() > 1) {
            assert (relevantChildrenOfElement.size() == 2);
            ArrayList<Edge> result = new ArrayList<Edge>(2);
            int ind = 0;
            for (ARGState elem : relevantChildrenOfElement) {
                Stack<FunctionBody> newStack = this.cloneStack(functionStack);
                CFAEdge e = currentElement.getEdgeToChild(elem);
                FunctionBody currentFunction = newStack.peek();
                assert (e instanceof CAssumeEdge);
                CAssumeEdge assumeEdge = (CAssumeEdge)e;
                boolean truthAssumption = assumeEdge.getTruthAssumption();
                String cond = "";
                if (ind == 0) {
                    cond = "if ";
                } else if (ind == 1) {
                    cond = "else if ";
                } else assert (false);
                ++ind;
                cond = truthAssumption ? cond + "(" + assumeEdge.getExpression().toASTString() + ")" : cond + "(!(" + assumeEdge.getExpression().toASTString() + "))";
                currentFunction.enterBlock(currentElement.getStateId(), assumeEdge, cond);
                Edge newEdge = new Edge(elem, e, newStack);
                result.add(newEdge);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static FunctionBody processIncomingStacks(List<FunctionBody> pIncomingStacks) {
        FunctionBody maxStack = null;
        int maxSizeOfStack = 0;
        for (FunctionBody stack : pIncomingStacks) {
            while (stack.getCurrentBlock().isClosedBefore()) {
                stack.leaveBlock();
            }
            if (stack.size() <= maxSizeOfStack) continue;
            maxStack = stack;
            maxSizeOfStack = maxStack.size();
        }
        return maxStack;
    }

    private void processEdge(ARGState childElement, CFAEdge edge, Stack<FunctionBody> functionStack) {
        FunctionBody currentFunction = functionStack.peek();
        if (childElement.isTarget()) {
            currentFunction.write("__VERIFIER_error(); // target state ");
        }
        if (edge instanceof CFunctionCallEdge) {
            String freshFunctionName = this.startFunction(childElement, functionStack);
            currentFunction.write(this.processFunctionCall(edge, freshFunctionName));
        } else if (edge instanceof CFunctionReturnEdge) {
            functionStack.pop();
        } else {
            currentFunction.write(this.processSimpleEdge(edge, currentFunction.getCurrentBlock()));
        }
    }

    private String processSimpleEdge(CFAEdge pCFAEdge, BasicBlock currentBlock) {
        switch (pCFAEdge.getEdgeType()) {
            case BlankEdge: 
            case StatementEdge: 
            case ReturnStatementEdge: {
                return pCFAEdge.getCode();
            }
            case AssumeEdge: {
                CAssumeEdge lAssumeEdge = (CAssumeEdge)pCFAEdge;
                return "__VERIFIER_assume(" + lAssumeEdge.getCode() + ");";
            }
            case DeclarationEdge: {
                CDeclarationEdge lDeclarationEdge = (CDeclarationEdge)pCFAEdge;
                if (lDeclarationEdge.getDeclaration().isGlobal()) {
                    this.mGlobalDefinitionsList.add(lDeclarationEdge.getCode());
                    return "";
                }
                if (currentBlock.hasDeclaration(lDeclarationEdge)) {
                    return "";
                }
                currentBlock.addDeclaration(lDeclarationEdge);
                return lDeclarationEdge.getCode();
            }
            case MultiEdge: {
                StringBuilder sb = new StringBuilder();
                for (CFAEdge edge : (MultiEdge)pCFAEdge) {
                    sb.append(this.processSimpleEdge(edge, currentBlock));
                }
                return sb.toString();
            }
        }
        throw new AssertionError((Object)("Unexpected edge " + pCFAEdge + " of type " + (Object)((Object)pCFAEdge.getEdgeType())));
    }

    private String processFunctionCall(CFAEdge pCFAEdge, String functionName) {
        CFunctionCallEdge lFunctionCallEdge = (CFunctionCallEdge)pCFAEdge;
        List lArguments = Lists.transform(lFunctionCallEdge.getArguments(), RAW_SIGNATURE_FUNCTION);
        String lArgumentString = "(" + Joiner.on((String)", ").join((Iterable)lArguments) + ")";
        CFunctionSummaryEdge summaryEdge = lFunctionCallEdge.getSummaryEdge();
        if (summaryEdge == null) {
            return functionName + lArgumentString + ";";
        }
        CFunctionCall expressionOnSummaryEdge = summaryEdge.getExpression();
        if (expressionOnSummaryEdge instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignExp = (CFunctionCallAssignmentStatement)expressionOnSummaryEdge;
            String assignedVarName = assignExp.getLeftHandSide().toASTString();
            return assignedVarName + " = " + functionName + lArgumentString + ";";
        }
        assert (expressionOnSummaryEdge instanceof CFunctionCallStatement);
        return functionName + lArgumentString + ";";
    }

    private String getFreshFunctionName(FunctionEntryNode functionStartNode) {
        return functionStartNode.getFunctionName() + "_" + this.mFunctionIndex++;
    }

    private Stack<FunctionBody> cloneStack(Stack<FunctionBody> pStack) {
        Stack<FunctionBody> ret = new Stack<FunctionBody>();
        for (FunctionBody functionBody : pStack) {
            ret.push(new FunctionBody(functionBody));
        }
        return ret;
    }
}

