/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;

public class AutomatonInfo {
    private final Map<Integer, AutomatonInternalState> idToState = new HashMap<Integer, AutomatonInternalState>();
    private final Map<String, ControlAutomatonCPA> nameToCPA = new HashMap<String, ControlAutomatonCPA>();

    AutomatonInfo() {
    }

    void register(Automaton automaton, ControlAutomatonCPA cpa) {
        for (AutomatonInternalState state : automaton.getStates()) {
            this.idToState.put(state.getStateId(), state);
        }
        this.nameToCPA.put(automaton.getName(), cpa);
    }

    public AutomatonInternalState getStateById(int id) {
        return this.idToState.get(id);
    }

    public ControlAutomatonCPA getCPAForAutomaton(String automatonName) {
        return this.nameToCPA.get(automatonName);
    }
}

