/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.apron.ApronManager;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.util.globalinfo.AutomatonInfo;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class GlobalInfo {
    private static GlobalInfo instance;
    private CFAInfo cfaInfo;
    private AutomatonInfo automatonInfo = new AutomatonInfo();
    private ConfigurableProgramAnalysis cpa;
    private FormulaManagerView formulaManager;
    private ArrayList<Serializable> helperStorages = new ArrayList();
    private AbstractionManager absManager;
    private ApronManager apronManager;
    private LogManager logger;

    private GlobalInfo() {
    }

    public static GlobalInfo getInstance() {
        if (instance == null) {
            instance = new GlobalInfo();
        }
        return instance;
    }

    public void storeCFA(CFA cfa) {
        this.cfaInfo = new CFAInfo(cfa);
    }

    public Optional<CFAInfo> getCFAInfo() {
        return Optional.fromNullable((Object)this.cfaInfo);
    }

    public void storeAutomaton(Automaton automaton, ControlAutomatonCPA automatonCPA) {
        this.automatonInfo.register(automaton, automatonCPA);
    }

    public AutomatonInfo getAutomatonInfo() {
        Preconditions.checkState((this.automatonInfo != null ? 1 : 0) != 0);
        return this.automatonInfo;
    }

    public void storeCPA(ConfigurableProgramAnalysis cpa) {
        this.cpa = cpa;
    }

    public Optional<ConfigurableProgramAnalysis> getCPA() {
        return Optional.fromNullable((Object)this.cpa);
    }

    public void storeFormulaManager(FormulaManagerView formulaManager) {
        this.formulaManager = formulaManager;
    }

    public void storeAbstractionManager(AbstractionManager absManager) {
        this.absManager = absManager;
    }

    public void storeApronManager(ApronManager pApronManager) {
        this.apronManager = pApronManager;
    }

    public void storeLogManager(LogManager pLogManager) {
        this.logger = pLogManager;
    }

    public FormulaManagerView getFormulaManager() {
        Preconditions.checkState((this.formulaManager != null ? 1 : 0) != 0);
        return this.formulaManager;
    }

    public AbstractionManager getAbstractionManager() {
        Preconditions.checkState((this.absManager != null ? 1 : 0) != 0);
        return this.absManager;
    }

    public ApronManager getApronManager() {
        return this.apronManager;
    }

    public LogManager getLogManager() {
        return this.logger;
    }

    public int addHelperStorage(Serializable e) {
        this.helperStorages.add(e);
        return this.helperStorages.size() - 1;
    }

    public Serializable getHelperStorage(int index) {
        return this.helperStorages.get(index);
    }

    public int getNumberOfHelperStorages() {
        return this.helperStorages.size();
    }
}

